/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.sending;

import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.jobs.manip.IIndexUpdater;
import ch.transsoft.edec.service.backend.jobs.manip.IndexUpdate;
import ch.transsoft.edec.service.backend.jobs.sending.SendingEntry;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.util.SendingUtil;

public class CreateSendingFromSendingEntry
extends BackendJobBase {
    private final SendingEntry sendingEntry;
    private IIndexUpdater update;

    public CreateSendingFromSendingEntry(SendingEntry sendingEntry) {
        super(IConfigService.Module.moduleExport);
        this.sendingEntry = sendingEntry;
    }

    @Override
    public void done() {
        this.update.notifyChange();
    }

    @Override
    public void execute() throws Exception {
        Sending sending = this.sendingEntry.sending;
        sending.setSendingId(SendingUtil.createSendingId(sending));
        sending.getArchive().setValue(false);
        if (this.sendingEntry.al != null) {
            this.saveAl(sending, this.sendingEntry.al);
        }
        boolean evvValid = this.saveEvvToDisk(sending.getSendingId(), this.sendingEntry.evv);
        sending.getState().setEvvValid(evvValid);
        this.saveSending(sending);
        this.update = new IndexUpdate(sending.getIndexEntry());
        this.update.saveOrUpdateIndex();
    }

    @Override
    public String getMessage() {
        return Services.getText(879);
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, Services.getText(880));
    }

    @Override
    public boolean locksActions() {
        return true;
    }
}

