/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.template;

import ch.transsoft.edec.model.infra.XMLReader;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.model.masterdata.Addresses;
import ch.transsoft.edec.model.masterdata.Carriers;
import ch.transsoft.edec.model.masterdata.Consignors;
import ch.transsoft.edec.model.masterdata.Currencies;
import ch.transsoft.edec.model.masterdata.Currency;
import ch.transsoft.edec.model.masterdata.Declarants;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.goodsdeclaration.Address;
import ch.transsoft.edec.model.sending.goodsdeclaration.Carrier;
import ch.transsoft.edec.model.sending.goodsdeclaration.Consignor;
import ch.transsoft.edec.model.sending.goodsdeclaration.Declarant;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.app.IAppService;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.jobs.template.IPatch;
import ch.transsoft.edec.service.backend.jobs.template.Patch;
import ch.transsoft.edec.service.backend.jobs.template.PatchDialog;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.service.masterdata.DataFiles;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class OpenTemplateJob
extends BackendJobBase {
    private Sending sending;
    private final File file;
    private final List<IPatch> patches = new ArrayList<IPatch>();

    public OpenTemplateJob(File file) {
        super(IConfigService.Module.moduleExport);
        this.file = file;
    }

    @Override
    public void done() {
        Services.get(IAppService.class).openTemplate(this.file, this.sending);
        Services.get(IGuiService.class).selectImportOrSending(this.sending.getGoodsDeclaration().getConsignee().getId().getValue());
        if (this.patches.isEmpty()) {
            return;
        }
        if (Services.get(IConfigService.class).getOptionInfo().getTemplateInfo().getAutoPatch().getValue().booleanValue()) {
            for (IPatch patch : this.patches) {
                patch.apply();
            }
            return;
        }
        SwingUtilities.invokeLater(() -> {
            PatchDialog dialog = new PatchDialog(this.patches);
            dialog.setVisible(true);
        });
    }

    @Override
    public void execute() throws Exception {
        XMLReader reader = new XMLReader();
        this.sending = reader.read(new FileInputStream(this.file), Sending.class);
        this.adjustSending();
        this.adjustCurrencies();
        this.sending.clearPendingChanges();
        this.computePatches();
    }

    private void adjustCurrencies() throws Exception {
        Currencies currencies = this.readMasterData(DataFiles.currency);
        if (currencies == null) {
            return;
        }
        for (Currency current : currencies.getCurrencyList()) {
            if (!current.getName().isInitialized() || !current.getRate().isInitialized()) continue;
            this.sending.setCurrencyRate(current.getName().getValue(), current.getRate().getValue());
        }
    }

    private void computePatches() throws Exception {
        this.patchConsignor();
        this.patchDeclarant();
        this.patchConsignee();
        this.patchDelivery();
        this.patchCarrier();
    }

    private void patchConsignor() throws Exception {
        Consignors items = this.readMasterData(DataFiles.consignor);
        if (items == null) {
            return;
        }
        Consignor target = this.sending.getGoodsDeclaration().getConsignor();
        if (!target.getId().isInitialized()) {
            return;
        }
        Consignor source = this.findConsignor(items.getConsignorList(), target.getId());
        if (source == null) {
            return;
        }
        if (target.isEquals(source)) {
            return;
        }
        this.patches.add(new Patch<Consignor>(Services.getText(1150), target, source));
    }

    private void patchDeclarant() throws Exception {
        Declarants items = this.readMasterData(DataFiles.declarant);
        if (items == null) {
            return;
        }
        Declarant target = this.sending.getGoodsDeclaration().getDeclarant();
        if (!target.getDeclarantNumber().isInitialized()) {
            return;
        }
        Declarant source = this.findDeclarant(items.getDeclarantList(), target.getDeclarantNumber());
        if (source == null) {
            return;
        }
        if (target.isEquals(source)) {
            return;
        }
        this.patches.add(new Patch<Declarant>(Services.getText(1151), target, source));
    }

    private void patchConsignee() throws Exception {
        Addresses items = this.readMasterData(DataFiles.address);
        if (items == null) {
            return;
        }
        Address target = this.sending.getGoodsDeclaration().getConsignee();
        if (!target.getId().isInitialized()) {
            return;
        }
        Address source = this.findAddress(items.getAddresses(), target.getId());
        if (source == null) {
            return;
        }
        if (target.isEquals(source)) {
            return;
        }
        this.patches.add(new Patch<Address>(Services.getText(1110), target, source));
    }

    private void patchDelivery() throws Exception {
        Address target = this.sending.getGoodsDeclaration().getDelivery();
        if (!target.isEnabled()) {
            return;
        }
        Addresses items = this.readMasterData(DataFiles.address);
        if (items == null) {
            return;
        }
        if (!target.getId().isInitialized()) {
            return;
        }
        Address source = this.findAddress(items.getAddresses(), target.getId());
        if (source == null) {
            return;
        }
        if (target.isEquals(source)) {
            return;
        }
        this.patches.add(new Patch<Address>(Services.getText(1111), target, source));
    }

    private void patchCarrier() throws Exception {
        Carriers items = this.readMasterData(DataFiles.carrier);
        if (items == null) {
            return;
        }
        Carrier target = this.sending.getGoodsDeclaration().getCarrier();
        if (!target.getId().isInitialized()) {
            return;
        }
        Carrier source = this.findCarrier(items.getCarrierList(), target.getId());
        if (source == null) {
            return;
        }
        if (target.isEquals(source)) {
            return;
        }
        this.patches.add(new Patch<Carrier>(Services.getText(1113), target, source));
    }

    private Consignor findConsignor(ListNode<Consignor> list, StringNode id) {
        for (Consignor current : list) {
            if (!current.getId().isInitialized() || !current.getId().getValue().equals(id.getValue())) continue;
            return current;
        }
        return null;
    }

    private Declarant findDeclarant(ListNode<Declarant> list, IntegralNode id) {
        for (Declarant current : list) {
            if (!current.getDeclarantNumber().isInitialized() || !current.getDeclarantNumber().getValue().equals(id.getValue())) continue;
            return current;
        }
        return null;
    }

    private Address findAddress(ListNode<Address> list, StringNode id) {
        for (Address current : list) {
            if (!current.getId().isInitialized() || !current.getId().getValue().equals(id.getValue())) continue;
            return current;
        }
        return null;
    }

    private Carrier findCarrier(ListNode<Carrier> list, StringNode id) {
        for (Carrier current : list) {
            if (!current.getId().isInitialized() || !current.getId().getValue().equals(id.getValue())) continue;
            return current;
        }
        return null;
    }

    private void adjustSending() {
        this.sending.setSendingId(null);
        this.sending.getHistory().clear();
        this.sending.getArchive().clear();
    }

    @Override
    public String getMessage() {
        return Services.getText(833) + " " + this.file.getName();
    }

    @Override
    public boolean needsLocking() {
        return true;
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, Services.getText(834) + " " + this.file.toString());
    }

    @Override
    public boolean showWaitCursor() {
        return true;
    }

    @Override
    public boolean locksActions() {
        return true;
    }
}

