/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.template;

import ch.transsoft.edec.model.config.conf.options.OptionInfo;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.jobs.template.IPatch;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.ui.pm.model.BooleanPm;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.util.Check;
import java.util.List;
import javax.swing.JButton;
import javax.swing.table.AbstractTableModel;

public class PatchDialogPm
extends AbstractTableModel
implements IPm {
    private JButton OKbutton;
    private OptionInfo optionInfo;
    private BooleanPm autoPatch;
    private final List<IPatch> patches;

    public PatchDialogPm(List<IPatch> patches) {
        this.patches = patches;
        this.OKbutton = new JButton(Services.getText(212));
        this.optionInfo = Services.get(IConfigService.class).getOptionInfo();
        this.autoPatch = new BooleanPm(this.optionInfo.getTemplateInfo().getAutoPatch());
    }

    public JButton getOKbutton() {
        return this.OKbutton;
    }

    public void save() {
        Services.get(IConfigService.class).saveOptionInfo(this.optionInfo);
    }

    public OptionInfo getOptionInfo() {
        return this.optionInfo;
    }

    public BooleanPm getAutoPatch() {
        return this.autoPatch;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.patches.size();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Boolean.class;
        }
        if (columnIndex == 1) {
            return String.class;
        }
        throw Check.fail("unexpected column", columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return Services.getText(843);
        }
        if (column == 1) {
            return Services.getText(844);
        }
        throw Check.fail("unexpected column", column);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Check.assertTrue(columnIndex == 0, "unexpected column", columnIndex);
        IPatch patch = this.patches.get(rowIndex);
        patch.setDoIt((Boolean)aValue);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        IPatch patch = this.patches.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return patch.isDoIt();
            }
            case 1: {
                return patch.getDescription();
            }
        }
        throw Check.fail("Unknown columnIndex", columnIndex);
    }

    public void okPressed() {
        for (IPatch patch : this.patches) {
            patch.apply();
        }
        if (this.optionInfo.getTemplateInfo().getAutoPatch().getValue().booleanValue()) {
            Services.get(IConfigService.class).saveOptionInfo(this.optionInfo);
        }
    }
}

