/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.certificate;

import ch.transsoft.edec.model.config.conf.license.CertificateInfo;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.certificate.ICertificateService;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.util.Base64;
import ch.transsoft.edec.util.Check;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class CertificateService
implements ICertificateService {
    @Override
    public void init() {
        try {
            new URL("https://");
        }
        catch (MalformedURLException e2) {
            Check.fail(e2);
        }
        this.updateCertificate();
    }

    @Override
    public void updateCertificate() {
        try {
            if (Services.get(IConfigService.class).hasCertificate()) {
                this.setKeyAndTrustStore();
            } else {
                this.setTrustStoreOnly();
            }
        }
        catch (Exception e2) {
            Check.fail(e2);
        }
    }

    @Override
    public void setTrustStoreOnly() throws Exception {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{new TrustAllX509TrustManager()}, null);
        SSLSocketFactory socketFactory = sslContext.getSocketFactory();
        HttpsURLConnection.setDefaultSSLSocketFactory(socketFactory);
    }

    void setKeyAndTrustStore() throws Exception {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        KeyManagerFactory kmf = this.getKeyManagerFactory();
        sslContext.init(kmf.getKeyManagers(), new TrustManager[]{new TrustAllX509TrustManager()}, null);
        SSLSocketFactory socketFactory = sslContext.getSocketFactory();
        HttpsURLConnection.setDefaultSSLSocketFactory(socketFactory);
    }

    private KeyManagerFactory getKeyManagerFactory() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        KeyStore clientKeyStore = KeyStore.getInstance("PKCS12");
        CertificateInfo certificateInfo = Services.get(IConfigService.class).getLicenseInfo().getCertificate();
        Check.assertTrue(certificateInfo.getCertificatePassword().isInitialized(), "Certificate password missing");
        Check.assertTrue(certificateInfo.getCertificateData().isInitialized(), "Certificate missing");
        ByteArrayInputStream cert = new ByteArrayInputStream(Base64.decode(certificateInfo.getCertificateData().getValue()));
        char[] certPassword = certificateInfo.getCertificatePassword().getValue().toCharArray();
        clientKeyStore.load(cert, certPassword);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(clientKeyStore, certPassword);
        return kmf;
    }

    @Override
    public Collection<InputStream> getEzvRootCertificates() {
        return Arrays.asList(CertificateService.class.getResourceAsStream("cert/AdminCA-CD-T01.cer"), CertificateService.class.getResourceAsStream("cert/cert2023/e_dec_Production_J5JS78_Swiss_Government_Regular_CA_02_.cer"), CertificateService.class.getResourceAsStream("cert/cert2023/Swiss_Government_Regular_CA_01_Swiss_Government_Root_CA_II_.cer"), CertificateService.class.getResourceAsStream("cert/cert2023/Swiss_Government_Regular_CA_02_Swiss_Government_Root_CA_III_.cer"), CertificateService.class.getResourceAsStream("cert/cert2023/Swiss_Government_Root_CA_II.cer"), CertificateService.class.getResourceAsStream("cert/cert2023/Swiss_Government_Root_CA_III.cer"));
    }

    public static final class TrustAllX509TrustManager
    implements X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }
}

