/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.config;

import ch.transsoft.edec.model.config.conf.Configuration;
import ch.transsoft.edec.model.config.conf.ProxyConfiguration;
import ch.transsoft.edec.model.config.conf.extract.ExportExtractInfo;
import ch.transsoft.edec.model.config.conf.extract.ImportExtractInfo;
import ch.transsoft.edec.model.config.conf.license.LicenseInfo;
import ch.transsoft.edec.model.config.conf.mail.MailInfo;
import ch.transsoft.edec.model.config.conf.options.OptionInfo;
import ch.transsoft.edec.model.config.conf.printer.PrintNameCorrection;
import ch.transsoft.edec.model.config.conf.printer.PrinterCorrection;
import ch.transsoft.edec.model.config.pref.Preferences;
import ch.transsoft.edec.model.config.pref.mandator.MandatorInfo;
import ch.transsoft.edec.model.config.pref.printer.PrinterSelection;
import ch.transsoft.edec.model.infra.XMLWriter;
import ch.transsoft.edec.model.infra.node.FileNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.sending.OperatingMode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.JobUtil;
import ch.transsoft.edec.service.backend.jobs.RecreateIndexJob;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.config.IConfigServiceListener;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.service.masterdata.DataFiles;
import ch.transsoft.edec.service.masterdata.IDataService;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.FileUtil;
import ch.transsoft.edec.util.UidUtil;
import ch.transsoft.edec.util.disposable.IDisposable;
import ch.transsoft.edec.util.disposable.ListenerList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class ConfigService
implements IConfigService {
    public static final String JNLP_FILE = "https://launcher.expovit-edec.ch/run.jnlp";
    public static final String ARCHIVE = "archive";
    public static final String CONFIG = "config";
    public static final String IMPORT = "import";
    public static final String INDEX = "index";
    public static final String MASTERDATA = "masterdata";
    public static final String SENDING = "sending";
    public static final String TEMPLATES = "templates";
    public static final String LANGUAGE_FILE = "language.txt";
    public static final String EXPOVIT = "expovit";
    public static final String EXAMPLE_CONTENT = "ExampleContent";
    public static final String BORDEREAU = "bordereau";
    public static final String DOCS = "docs";
    public static final String RECEIPT = "receipt";
    public static final String EVV_IMPORT = "evv import";
    public static final String LOCK_FILE_IMPORT = "lock_import";
    public static final String LOCK_FILE_EXPORT = "lock_export";
    public static final String VERSION_FILE = "version.txt";
    private final ListenerList<IConfigServiceListener> listeners = new ListenerList();
    private Preferences preferences;
    private Configuration configuration;
    private ProxyConfiguration proxyConfiguration;
    private boolean testSystem = false;
    private boolean useNewLocalConfigDir;

    public ConfigService() {
        this.setLocalConfigDear();
    }

    private void setLocalConfigDear() {
        File newDir = this.getRoamingDir();
        if (newDir == null) {
            this.useNewLocalConfigDir = false;
            return;
        }
        File newExpovitDir = new File(newDir, EXPOVIT);
        if (newExpovitDir.exists()) {
            this.useNewLocalConfigDir = true;
            return;
        }
        try {
            this.useNewLocalConfigDir = this.migrateLocalConfigDir(newExpovitDir);
        }
        catch (Exception e2) {
            this.useNewLocalConfigDir = false;
        }
    }

    private boolean migrateLocalConfigDir(File newExpovitDir) throws IOException {
        if (!this.bestEffortMkdirs(newExpovitDir)) {
            return false;
        }
        if (this.getOldLocalConfigDir().getCanonicalPath().equals(newExpovitDir.getCanonicalPath())) {
            return false;
        }
        FileUtil.recursiveCopy(this.getOldLocalConfigDir(), newExpovitDir);
        return true;
    }

    @Override
    public File getLogFilePath() {
        File dir = this.getLogFolder();
        this.bestEffortMkdirs(dir);
        return new File(dir, "expovit-edec.log");
    }

    @Override
    public File getLogFolder() {
        File configDir = this.getLocalConfigDir();
        return new File(configDir, "log");
    }

    private File getOldLocalConfigDir() {
        File result = new File(this.getUserHome(), EXPOVIT);
        this.bestEffortMkdirs(result);
        return result;
    }

    @Override
    public File getDefaultRootDir() {
        return new File(this.getLocalConfigDir(), EXAMPLE_CONTENT);
    }

    private File getRoamingDir() {
        String profile = System.getenv("APPDATA");
        if (profile == null) {
            return null;
        }
        return new File(profile);
    }

    private File getLocalConfigDir() {
        if (this.useNewLocalConfigDir) {
            return new File(this.getRoamingDir(), EXPOVIT);
        }
        return this.getOldLocalConfigDir();
    }

    @Override
    public File getLanguageFilePath() {
        return new File(this.getLocalConfigDir(), LANGUAGE_FILE);
    }

    @Override
    public File getPreferencesDir(boolean readOnly) {
        return this.getLocalConfigDir();
    }

    @Override
    public String getUserName() {
        return System.getProperty("user.name");
    }

    private File getUserHome() {
        File home = new File(System.getProperty("user.home"));
        if (home.exists()) {
            return home;
        }
        return new File(System.getenv("USERPROFILE"));
    }

    @Override
    public boolean isTestSystem() {
        return this.getOperatingModeForActiveModule() == OperatingMode.test;
    }

    @Override
    public String getVersionString() {
        try {
            Properties props = new Properties();
            props.load(this.getClass().getResourceAsStream("version.properties"));
            String version = props.getProperty("version");
            if (version == null) {
                return "<version>";
            }
            return version;
        }
        catch (Exception e2) {
            return "<version>";
        }
    }

    @Override
    public synchronized OperatingMode getOperatingModeForActiveModule() {
        if (!this.hasCertificate()) {
            return OperatingMode.undefined;
        }
        if (this.getLicenseInfo().getStartInTestMode().getValue().booleanValue()) {
            return OperatingMode.test;
        }
        if (!this.hasLicenseForActiveModule()) {
            return OperatingMode.test;
        }
        return this.testSystem ? OperatingMode.test : OperatingMode.production;
    }

    @Override
    public void setOperatingMode(OperatingMode mode) {
        if (mode == OperatingMode.production) {
            Check.assertTrue(this.hasLicense(), "Zugriff auf das Produktivsystem ist gesperrt, da keine Lizenz erworben wurde.");
        }
        this.testSystem = mode == OperatingMode.test;
        this.getLicenseInfo().getStartInTestMode().setValue(mode == OperatingMode.test);
        this.saveLicenseInfo(this.getLicenseInfo());
        this.triggerModeChanged();
    }

    @Override
    public boolean registrationComplete() {
        if (!this.hasCertificate()) {
            return false;
        }
        return this.hasLicense();
    }

    @Override
    public File getIndexDir(boolean readOnly) {
        File dir = new File(this.getRootDir(), INDEX);
        if (!readOnly) {
            this.bestEffortMkdirs(dir);
        }
        return dir;
    }

    @Override
    public File getDefaultImportDir(boolean readOnly) {
        File dir = new File(this.getRootDir(), IMPORT);
        if (!readOnly) {
            this.bestEffortMkdirs(dir);
        }
        return dir;
    }

    @Override
    public File getArchiveDir(boolean readOnly) {
        File dir = new File(this.getRootDir(), ARCHIVE);
        if (!readOnly) {
            this.bestEffortMkdirs(dir);
        }
        return dir;
    }

    @Override
    public File getBordereauArchiveDir(boolean readOnly) {
        File dir = new File(this.getBordereauDir(), ARCHIVE);
        if (!readOnly) {
            this.bestEffortMkdirs(dir);
        }
        return dir;
    }

    private boolean bestEffortMkdirs(File dir) {
        return dir.mkdirs();
    }

    @Override
    public File getBordereauIndexDir(boolean readOnly) {
        File dir = new File(this.getBordereauDir(), INDEX);
        if (!readOnly) {
            this.bestEffortMkdirs(dir);
        }
        return dir;
    }

    @Override
    public File getBordereauDocsDir(boolean readOnly) {
        File dir = new File(this.getBordereauDir(), DOCS);
        if (!readOnly) {
            this.bestEffortMkdirs(dir);
        }
        return dir;
    }

    @Override
    public File getBordereauDir() {
        return new File(this.getEvvImportDir(), BORDEREAU);
    }

    @Override
    public File getReceiptArchiveDir(boolean readOnly) {
        File dir = new File(this.getReceiptDir(), ARCHIVE);
        if (!readOnly) {
            this.bestEffortMkdirs(dir);
        }
        return dir;
    }

    @Override
    public File getReceiptIndexDir(boolean readOnly) {
        File dir = new File(this.getReceiptDir(), INDEX);
        if (!readOnly) {
            this.bestEffortMkdirs(dir);
        }
        return dir;
    }

    @Override
    public File getReceiptDocsDir(boolean readOnly) {
        File dir = new File(this.getReceiptDir(), DOCS);
        if (!readOnly) {
            this.bestEffortMkdirs(dir);
        }
        return dir;
    }

    private File getReceiptDir() {
        return new File(this.getEvvImportDir(), RECEIPT);
    }

    File getEvvImportDir() {
        return new File(this.getRootDir(), EVV_IMPORT);
    }

    @Override
    public File getMasterDataDir(boolean readOnly) {
        File dir = new File(this.getRootDir(), MASTERDATA);
        if (!readOnly) {
            this.bestEffortMkdirs(dir);
        }
        return dir;
    }

    @Override
    public File getConfigDir(boolean readOnly) {
        File dir = new File(this.getRootDir(), CONFIG);
        if (!readOnly) {
            this.bestEffortMkdirs(dir);
        }
        return dir;
    }

    @Override
    public File getSendingDir(boolean readOnly) {
        File dir = new File(this.getRootDir(), SENDING);
        if (!readOnly) {
            this.bestEffortMkdirs(dir);
        }
        return dir;
    }

    @Override
    public File getTemplateDir(boolean readOnly) {
        File dir = new File(this.getRootDir(), TEMPLATES);
        if (!readOnly) {
            this.bestEffortMkdirs(dir);
        }
        return dir;
    }

    @Override
    public File getLockFilePath(IConfigService.Module module) {
        switch (module) {
            case moduleExport: {
                return new File(this.getRootDir(), LOCK_FILE_EXPORT);
            }
            case moduleImport: {
                return new File(this.getRootDir(), LOCK_FILE_IMPORT);
            }
        }
        throw new IllegalArgumentException("Unknown module: " + module);
    }

    @Override
    public File getVersionFilePath() {
        return new File(this.getConfigDir(false), VERSION_FILE);
    }

    private File getRootDir() {
        File result;
        FileNode rootFolder = this.getPreferences().getRootFolder();
        if (rootFolder.isInitialized() && (result = rootFolder.getValue()).exists()) {
            return result;
        }
        return this.getDefaultRootDir();
    }

    @Override
    public File getTempDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    @Override
    public IDisposable add(IConfigServiceListener listener) {
        return this.listeners.add(listener);
    }

    @Override
    public void changeRootFolder(File newRoot, boolean copyData) {
        File oldRoot = this.getRootFolder();
        this.getPreferences().getRootFolder().setValue(newRoot);
        this.savePreferences();
        if (copyData) {
            this.copyData(oldRoot, newRoot);
            Services.get(IBackendService.class).put(new RecreateIndexJob());
        }
        this.configuration = null;
        this.triggerRootChanged();
        this.triggerConfigChanged();
    }

    private void copyData(File oldRoot, File newRoot) {
        try {
            this.copySubFolder(oldRoot, newRoot, ARCHIVE);
            this.copySubFolder(oldRoot, newRoot, CONFIG);
            this.copySubFolder(oldRoot, newRoot, IMPORT);
            this.copySubFolder(oldRoot, newRoot, INDEX);
            this.copySubFolder(oldRoot, newRoot, MASTERDATA);
            this.copySubFolder(oldRoot, newRoot, SENDING);
            this.copySubFolder(oldRoot, newRoot, TEMPLATES);
        }
        catch (IOException e2) {
            Services.get(ILoggingService.class).logAndReport(e2, Services.getText(638));
        }
    }

    private void copySubFolder(File oldRoot, File newRoot, String subfolder) throws IOException {
        FileUtil.recursiveCopy(new File(oldRoot, subfolder), new File(newRoot, subfolder));
    }

    @Override
    public void savePreferences() {
        Services.get(IDataService.class).saveMasterData(this.getPreferences());
    }

    private void saveConfiguration(Configuration configuration) {
        try {
            XMLWriter writer = new XMLWriter();
            File path = JobUtil.getMasterDataPath(configuration.getDataFileType(), false);
            writer.write(path, configuration, true);
        }
        catch (Exception e2) {
            Check.fail(e2, "Configuration could not be saved.");
        }
        this.triggerConfigChanged();
    }

    @Override
    public File getRootFolder() {
        return this.getPreferences().getRootFolder().getValueSave();
    }

    @Override
    public boolean hasRootFolder() {
        return this.getPreferences().getRootFolder().isInitialized();
    }

    @Override
    public Preferences getPreferences() {
        if (this.preferences == null) {
            try {
                this.preferences = Services.get(IDataService.class).readSync(DataFiles.preferences);
                if (this.preferences.getMailPreferenceInfo().getEmailChannel().getValue() == -1L) {
                    this.preferences.getMailPreferenceInfo().getEmailChannel().setValue(this.getOptionInfo().getMailOptionInfo().getEmailChannel().getValue());
                }
            }
            catch (Exception e2) {
                Check.fail(e2, "Preferences.xml konnten nicht gelesen werden: " + JobUtil.getMasterDataPath(DataFiles.preferences, true));
            }
        }
        return this.preferences;
    }

    private Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = this.readConfiguration();
        }
        return this.configuration;
    }

    private void triggerRootChanged() {
        for (IConfigServiceListener listener : this.listeners) {
            listener.rootChanged();
        }
    }

    private void triggerConfigChanged() {
        Check.checkEDT();
        for (IConfigServiceListener listener : this.listeners) {
            listener.configurationChanged();
        }
    }

    private void triggerModeChanged() {
        for (IConfigServiceListener listener : this.listeners) {
            listener.modeChanged(this.testSystem);
        }
    }

    private Configuration readConfiguration() {
        try {
            return Services.get(IDataService.class).readSync(DataFiles.configuration);
        }
        catch (Exception e2) {
            throw Check.fail(e2, "Die Konfiguration konnte nicht gelesen werden.");
        }
    }

    @Override
    public PrinterSelection getPrinterSelection() {
        return this.getPreferences().getPrinterSelection();
    }

    @Override
    public void savePrinterSelection(PrinterSelection selection) {
        this.getPreferences().setPrinterSelection(selection);
        this.savePreferences();
    }

    @Override
    public ImportExtractInfo getImportExtractInfo() {
        return this.getConfiguration().getImportExtractInfo();
    }

    @Override
    public void saveImportExtractInfo(ImportExtractInfo info) {
        this.configuration = this.readConfiguration();
        this.configuration.setImportExtractInfo(info);
        this.saveConfiguration(this.configuration);
    }

    @Override
    public ExportExtractInfo getExportExtractInfo() {
        return this.getConfiguration().getExportExtractInfo();
    }

    @Override
    public void saveExportExtractInfo(ExportExtractInfo info) {
        this.configuration = this.readConfiguration();
        this.configuration.setExportExtractInfo(info);
        this.saveConfiguration(this.configuration);
    }

    @Override
    public MandatorInfo getMandatorInfo() {
        return this.getPreferences().getMandatorInfo();
    }

    @Override
    public void saveMandatorInfo(MandatorInfo info) {
        this.getPreferences().setMandatorInfo(info);
        this.savePreferences();
    }

    @Override
    public PrinterCorrection getPrinterCorrection() {
        return this.getConfiguration().getPrinterCorrection();
    }

    @Override
    public PrintNameCorrection getPrintNameCorrection() {
        return this.getConfiguration().getPrintNameCorrection();
    }

    @Override
    public void savePrinterCorrection(PrinterCorrection correction) {
        this.configuration = this.readConfiguration();
        this.configuration.setPrinterCorrection(correction);
        this.saveConfiguration(this.configuration);
    }

    @Override
    public void savePrintNameCorrection(PrintNameCorrection correction) {
        this.configuration = this.readConfiguration();
        this.configuration.setPrintNameCorrection(correction);
        this.saveConfiguration(this.configuration);
    }

    @Override
    public LicenseInfo getLicenseInfo() {
        return this.getConfiguration().getLicenseInfo();
    }

    @Override
    public void saveLicenseInfo(LicenseInfo licenseInfo) {
        this.configuration = this.readConfiguration();
        this.configuration.setLicenseInfo(licenseInfo);
        this.saveConfiguration(this.configuration);
    }

    @Override
    public MailInfo getCarrierMailInfo() {
        return this.getConfiguration().getCarrierMailInfo();
    }

    @Override
    public MailInfo getAvisMailInfo() {
        return this.getConfiguration().getAvisMailInfo();
    }

    @Override
    public MailInfo getEvvMailInfo() {
        return this.getConfiguration().getEvvMailInfo();
    }

    @Override
    public MailInfo getReceiptImportMailInfo() {
        return this.getConfiguration().getReceiptImportMailInfo();
    }

    @Override
    public void saveCarrierMailInfo(MailInfo info) {
        this.configuration = this.readConfiguration();
        this.configuration.setCarrierMailInfo(info);
        this.saveConfiguration(this.configuration);
    }

    @Override
    public void saveReceiptImportMailInfo(MailInfo info) {
        this.configuration = this.readConfiguration();
        this.configuration.setReceiptImportMailInfo(info);
        this.saveConfiguration(this.configuration);
    }

    @Override
    public void saveAvisMailInfo(MailInfo info) {
        this.configuration = this.readConfiguration();
        this.configuration.setAvisMailInfo(info);
        this.saveConfiguration(this.configuration);
    }

    @Override
    public void saveEvvMailInfo(MailInfo info) {
        this.configuration = this.readConfiguration();
        this.configuration.setEvvMailInfo(info);
        this.saveConfiguration(this.configuration);
    }

    @Override
    public OptionInfo getOptionInfo() {
        return this.getConfiguration().getOptionInfo();
    }

    @Override
    public File getImportDir(boolean readOnly) {
        StringNode importPath = this.getOptionInfo().getImportInfo().getImportPath();
        if (!importPath.isInitialized()) {
            return this.getDefaultImportDir(true);
        }
        return new File(importPath.getValue());
    }

    @Override
    public Path getTransactionExportBacklogFile() {
        return this.getConfigDir(false).toPath().resolve("transaction-backlog.txt");
    }

    @Override
    public void saveOptionInfo(OptionInfo info) {
        this.configuration = this.readConfiguration();
        this.configuration.setOptionInfo(info);
        this.saveConfiguration(this.configuration);
        this.triggerConfigChanged();
    }

    @Override
    public void reloadConfiguration() {
        this.configuration = null;
        this.triggerConfigChanged();
    }

    @Override
    public boolean isRegistered() {
        return this.getLicenseInfo().getGuid().isInitialized();
    }

    @Override
    public boolean hasCertificate() {
        return this.getLicenseInfo().getCertificate().isReady();
    }

    @Override
    public String getGuid() {
        return this.getLicenseInfo().getGuid().getValue();
    }

    @Override
    public String getEdecExportIdentification() {
        return UidUtil.getEdecSchemaUid(this.getLicenseInfo().getCertificate().getUid().getValue());
    }

    @Override
    public String getEdecImportIdentification() {
        return this.getEdecExportIdentification();
    }

    @Override
    public boolean isModuleExport() {
        return this.getPreferences().getModuleSelection().getValue().getKeyAsInt() == 0;
    }

    @Override
    public boolean isModuleImport() {
        return !this.isModuleExport();
    }

    @Override
    public List<String> getAccountNumbers() {
        String numbersStr = this.getLicenseInfo().getZazNumber().getValue();
        numbersStr = numbersStr.replace(" ", "");
        String[] numberArray = numbersStr.split(";");
        return Arrays.asList(numberArray);
    }

    @Override
    public boolean hasLicense() {
        return this.getLicenseInfo().hasLicense();
    }

    @Override
    public boolean hasLicenseForActiveModule() {
        if (this.isModuleExport()) {
            return this.hasLicenseForModuleExport() || this.hasLicenseForModuleEvvExport();
        }
        return this.hasLicenseForModuleImport();
    }

    @Override
    public boolean hasLicenseForModuleImport() {
        return this.getLicenseInfo().hasLicenseForModuleEvvImport();
    }

    @Override
    public boolean hasLicenseForModuleExport() {
        return this.getLicenseInfo().hasLicenseForModuleEdecExport();
    }

    @Override
    public boolean hasLicenseForModuleEvvExport() {
        return this.getLicenseInfo().hasLicenseForModuleEvvExport();
    }

    @Override
    public ProxyConfiguration getProxyConfiguration() {
        if (this.proxyConfiguration == null) {
            this.proxyConfiguration = this.readProxyConfiguration();
        }
        return this.proxyConfiguration;
    }

    private ProxyConfiguration readProxyConfiguration() {
        try {
            return Services.get(IDataService.class).readSync(DataFiles.proxySettings);
        }
        catch (Exception e2) {
            throw Check.fail(e2, "Die Konfiguration konnte nicht gelesen werden.");
        }
    }

    @Override
    public void saveProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
        Services.get(IDataService.class).saveMasterDataNow(proxyConfiguration);
    }
}

