/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.ezv;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.logging.ILoggingService;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.handler.MessageContext;
import jakarta.xml.ws.handler.soap.SOAPHandler;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.Set;
import javax.xml.namespace.QName;

public class LoggingHandler
implements SOAPHandler<SOAPMessageContext> {
    @Override
    public boolean handleMessage(SOAPMessageContext c2) {
        try {
            this.logMessage(c2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public boolean handleFault(SOAPMessageContext c2) {
        try {
            this.logMessage(c2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private void logMessage(SOAPMessageContext c2) {
        SOAPMessage msg = c2.getMessage();
        String messateStr = this.getMessage(msg);
        Services.get(ILoggingService.class).logSilent(messateStr);
    }

    private String getMessage(SOAPMessage msg) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int ch;
            msg.writeTo(baos);
            InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(baos.toByteArray()), "utf-8");
            StringWriter writer = new StringWriter();
            while ((ch = reader.read()) != -1) {
                writer.append((char)ch);
            }
            return writer.toString();
        }
        catch (Exception e2) {
            return "Unable to serialize soap-message: " + e2.getMessage();
        }
    }

    @Override
    public void close(MessageContext c2) {
    }

    @Override
    public Set<QName> getHeaders() {
        return null;
    }
}

