/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.ezv;

import ch.e_dec.xml.schema.edecbordereauresponse.v1.BordereauDetailsType;
import ch.e_dec.xml.schema.edecreceiptrequest.v3.DocumentTypeType;
import ch.e_dec.xml.schema.edecreceiptresponse.v3.DocumentTypeList;
import ch.transsoft.edec.util.Check;

public enum ReceiptDocumentType {
    undefined{

        @Override
        public DocumentTypeType getDocumentType() {
            throw Check.fail("DocumentType is undefined");
        }
    }
    ,
    vve{

        @Override
        public DocumentTypeType getDocumentType() {
            return DocumentTypeType.TAXATION_DECISION_EXPORT;
        }
    }
    ,
    vvz{

        @Override
        public DocumentTypeType getDocumentType() {
            return DocumentTypeType.TAXATION_DECISION_CUSTOMS_DUTIES;
        }
    }
    ,
    vvm{

        @Override
        public DocumentTypeType getDocumentType() {
            return DocumentTypeType.TAXATION_DECISION_VAT;
        }
    }
    ,
    rbz{

        @Override
        public DocumentTypeType getDocumentType() {
            return DocumentTypeType.REFUND_CUSTOMS_DUTIES;
        }
    }
    ,
    rbm{

        @Override
        public DocumentTypeType getDocumentType() {
            return DocumentTypeType.REFUND_VAT;
        }
    };


    public abstract DocumentTypeType getDocumentType();

    public static ReceiptDocumentType getReceiptDocumentType(String documentType) {
        Check.assertNotNull(documentType);
        if (documentType.equals("taxationDecisionCustomsDuties")) {
            return vvz;
        }
        if (documentType.equals("taxationDecisionVAT")) {
            return vvm;
        }
        if (documentType.equals("refundCustomsDuties")) {
            return rbz;
        }
        if (documentType.equals("refundVAT")) {
            return rbm;
        }
        return null;
    }

    public static ReceiptDocumentType getReceiptDocumentType(DocumentTypeType type) {
        switch (type) {
            case TAXATION_DECISION_CUSTOMS_DUTIES: {
                return vvz;
            }
            case TAXATION_DECISION_VAT: {
                return vvm;
            }
            case REFUND_CUSTOMS_DUTIES: {
                return rbz;
            }
            case REFUND_VAT: {
                return rbm;
            }
        }
        throw Check.fail("Unknown DocumentType " + type);
    }

    public static ReceiptDocumentType getReceiptDocumentType(BordereauDetailsType.CustomsOffice.Detail.DocumentType type) {
        if (type.getDocumentTypeAbbreviation().equals("VVZ")) {
            return vvz;
        }
        if (type.getDocumentTypeAbbreviation().equals("VVM")) {
            return vvm;
        }
        if (type.getDocumentTypeAbbreviation().equals("RBZ")) {
            return rbz;
        }
        if (type.getDocumentTypeAbbreviation().equals("RBM")) {
            return rbm;
        }
        throw Check.fail("Unknown DocumentType " + type);
    }

    public static ReceiptDocumentType getReceiptDocumentType(DocumentTypeList type) {
        switch (type) {
            case TAXATION_DECISION_EXPORT: {
                return vve;
            }
            case TAXATION_DECISION_CUSTOMS_DUTIES: {
                return vvz;
            }
            case TAXATION_DECISION_VAT: {
                return vvm;
            }
            case REFUND_CUSTOMS_DUTIES: {
                return rbz;
            }
            case REFUND_VAT: {
                return rbm;
            }
        }
        throw Check.fail("Unknown DocumentType " + type);
    }
}

