/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.ezv.aza;

import ch.e_dec.services.edecservice.v4.GoodsDeclarationsFault;
import ch.e_dec.xml.schema.edecresponse.v4.DescriptionType;
import ch.e_dec.xml.schema.edecresponse.v4.GoodsDeclarationRejectionType;
import ch.e_dec.xml.schema.edecresponse.v4.RuleErrorType;
import ch.e_dec.xml.schema.edecresponse.v4.XMLSchemaErrorType;
import ch.transsoft.edec.model.infra.node.INode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.goodsdeclaration.GoodsDeclaration;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsItem;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.service.text.ITextService;
import ch.transsoft.edec.service.validate.ErrorMarker;
import ch.transsoft.edec.service.validate.IValidateService;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.ErrorUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AzaErrorHandler {
    private final Sending sending;

    public AzaErrorHandler(Sending sending, GoodsDeclarationsFault fault) {
        this.sending = sending;
        this.handleGoodsDeclarationFault(fault);
    }

    public static String getRuleErrorDescription(RuleErrorType.Error error) {
        Object result = error.getRuleName();
        result = (String)result + " (";
        result = (String)result + error.getReference();
        result = (String)result + ") ";
        return (String)result + AzaErrorHandler.getDescription(error);
    }

    private static String getDescription(RuleErrorType.Error error) {
        ITextService.Language language = Services.get(ITextService.class).getCurrentLanguage();
        List<DescriptionType.Description> errors = error.getDescriptions().getDescription();
        for (DescriptionType.Description current : errors) {
            if (!current.getLanguage().equals(language.name())) continue;
            return current.getValue();
        }
        if (errors.isEmpty()) {
            return Services.getText(915);
        }
        return errors.get(0).getValue();
    }

    private void handleGoodsDeclarationFault(GoodsDeclarationsFault fault) {
        List<GoodsDeclarationRejectionType> rejections = fault.getFaultInfo().getGoodsDeclarationRejection();
        if (rejections.isEmpty()) {
            Check.fail(fault, "rejection expected");
        }
        for (GoodsDeclarationRejectionType rejection : rejections) {
            this.handleRejection(rejection);
        }
    }

    private void handleRejection(GoodsDeclarationRejectionType rejection) {
        GoodsDeclarationRejectionType.Errors error = rejection.getErrors();
        if (error.getXMLSchemaErrors() != null) {
            this.handleSchemaError(error.getXMLSchemaErrors());
        }
        if (error.getRuleErrors() != null) {
            this.handleRuleErrors(error.getRuleErrors());
        }
        if (error.getCustomsRejection() != null) {
            this.handleCustomsRejection();
        }
    }

    private void handleCustomsRejection() {
        Services.get(ILoggingService.class).logAndReport(Services.getText(910));
    }

    private void handleRuleErrors(RuleErrorType ruleErrors) {
        ArrayList<String> errorList = new ArrayList<String>();
        HashSet<String> allErrorNames = new HashSet<String>();
        for (RuleErrorType.Error error : ruleErrors.getError()) {
            allErrorNames.add(error.getRuleName());
        }
        for (RuleErrorType.Error error : ruleErrors.getError()) {
            this.handleRuleError(error, errorList, allErrorNames);
        }
        if (errorList.isEmpty()) {
            return;
        }
        ErrorUtil.showErrors(Services.getText(884), errorList);
    }

    private void handleRuleError(RuleErrorType.Error error, List<String> errorList, Set<String> allErrorNames) {
        if (this.is(error, "E009c", "E009d")) {
            this.setError(this.getGoodsDeclaration().getTraderDeclarationNumber(), error, Services.getText(911));
        } else if (this.is(error, "E004")) {
            this.setError(this.getGoodsDeclaration().getTransportMeans().getTransportationCountry(), error);
        } else if (this.is(error, "E067d")) {
            this.setError(this.getItem(error).getSensibleGoods(), error, Services.getText(912));
        } else if (this.is(error, "E136")) {
            this.setError(this.getItem(error).getNotifications(), error);
        } else if (this.is(error, "E019")) {
            this.setError(this.getItem(error).getGoodsData().getAdditionalUnit(), error);
        } else if (this.is(error, "E020a", "E022")) {
            this.setError(this.getItem(error).getGoodsData().getAdditionalUnit(), error);
            this.setError(this.getItem(error).getConfirmation().getAdditionalUnitConfirmation(), error, Services.format(913, 1250));
        } else if (this.is(error, "E016a")) {
            this.setError(this.getItem(error).getGoodsData().getGrossMass(), error);
            this.setError(this.getItem(error).getConfirmation().getGrossMassConfirmation(), error, Services.format(913, 1207));
        } else if (this.is(error, "E015a")) {
            this.setError(this.getItem(error).getGoodsData().getStatisticalValue(), error);
            this.setError(this.getItem(error).getConfirmation().getStatisticalValueConfirmation(), error, Services.format(913, 1210));
        } else if (this.is(error, "E015b")) {
            this.setError(this.getItem(error).getGoodsData().getStatisticalValue(), error);
            this.setError(this.getItem(error).getConfirmation().getStatisticalValueConfirmation(), error, Services.format(913, 1210));
        } else if (this.is(error, "E050")) {
            this.setError(this.getItem(error).getGoodsData().getCommodityCode(), error);
        } else if (this.is(error, "E051")) {
            if (allErrorNames.contains("E050")) {
                return;
            }
            this.setError(this.getItem(error).getGoodsData().getStatisticalCode(), error);
        } else if (this.is(error, "E008")) {
            this.setError(this.getGoodsDeclaration().getDeliveryDestination(), error);
        } else if (this.is(error, "E010")) {
            this.setError(this.getGoodsDeclaration().getCorrectionCode(), error);
        } else if (this.is(error, "E011")) {
            this.setError(this.getGoodsDeclaration().getCorrectionCode(), error);
        } else if (this.is(error, "E012")) {
            this.setError(this.getGoodsDeclaration().getCorrectionCode(), error);
        } else if (this.is(error, "E013a", "E013b", "E013c")) {
            this.setError(this.getItem(error).getNonCustomLaws().getNonCustomsLawObligation(), error);
        } else if (this.is(error, "E014a", "E014b")) {
            this.setError(this.getItem(error).getNonCustomLaws(), error);
        } else if (this.is(error, "E018") || this.is(error, "E023")) {
            this.setError(this.getItem(error).getGoodsData().getNetMass(), error);
            this.setError(this.getItem(error).getConfirmation().getNetMassConfirmation(), error, Services.format(913, 1206));
        } else if (this.is(error, "E025a")) {
            this.setError(this.getItem(error).getGoodsData().getStatisticalValue(), error);
        } else if (this.is(error, "E025b")) {
            this.setError(this.getItem(error).getGoodsData().getNetMass(), error);
            this.setError(this.getItem(error).getGoodsData().getGrossMass(), error);
            this.setError(this.getItem(error).getGoodsData().getAdditionalUnit(), error);
        } else if (this.is(error, "E027a")) {
            this.setError(this.getItem(error).getGoodsData().getCustomsClearanceType(), error);
            this.setError(this.getItem(error).getGoodsData().getCommercialGood(), error);
        } else if (this.is(error, "E027b")) {
            this.setError(this.getItem(error).getGoodsData().getCustomsClearanceType(), error);
        } else if (this.is(error, "E041")) {
            this.setError(this.getGoodsDeclaration().getConsignor().getCountry(), error);
        } else if (this.is(error, "E042")) {
            this.setError(this.getGoodsDeclaration().getConsignor().getPostalCode(), error);
        } else if (this.is(error, "E046")) {
            this.setError(this.getGoodsDeclaration().getDeclarant().getDeclarantNumber(), error);
        } else if (this.is(error, "E067a", "E067b", "E067c")) {
            this.setError(this.getItem(error).getSensibleGoods(), error);
        } else if (this.is(error, "E071a", "E071b")) {
            this.setError(this.getItem(error).getPermits().getPermitObligation(), error);
        } else if (this.is(error, "E071c", "E072")) {
            this.setError(this.getItem(error).getPermits(), error);
        } else if (this.is(error, "E068", "E069")) {
            this.setError(this.getItem(error).getGoodsItemDetail(), error);
        } else if (this.is(error, "E096")) {
            this.setError(this.getItem(error).getGoodsData().getNetMass(), error);
        } else if (this.is(error, "E021a", "E021b", "E021c")) {
            this.setError(this.getItem(error).getGoodsData().getQuantity(), error);
            this.setError(this.getItem(error).getGoodsData().getPackagingReferenceNumber(), error);
        } else if (this.is(error, "E127ha")) {
            this.setError(this.getItem(error).getGoodsData().getVOCQuantity(), error);
        } else if (this.is(error, "E127b")) {
            this.setError(this.getItem(error).getGoodsData().getVOCQuantity(), error);
            this.setError(this.getItem(error).getGoodsData().getNetMass(), error);
        } else if (this.is(error, "E128a")) {
            this.setError(this.getItem(error).getGoodsData().getRefundType(), error);
            this.setError(this.getItem(error).getGoodsData().getCustomsClearanceType(), error);
        } else if (this.is(error, "E131")) {
            this.setError(this.getItem(error).getPermits(), error);
        } else if (this.is(error, "E132", "E133")) {
            this.setError(this.getItem(error).getRepairAndRefinement().getBillingType(), error);
        } else if (this.is(error, "E135")) {
            this.setError(this.getItem(error).getRepairAndRefinement().getDirection(), error);
        } else if (this.is(error, "E138")) {
            this.setError(this.getItem(error).getGoodsData().getCommercialGood(), error);
        } else if (this.is(error, "E139")) {
            this.setError(this.getItem(error).getPermits(), error);
        } else if (this.is(error, "E150")) {
            this.setError(this.getGoodsDeclaration().getCorrectionCode(), error);
        } else if (this.is(error, "E194")) {
            this.setError(this.getItem(error).getRepairAndRefinement().getDirection(), error);
        } else if (this.is(error, "R233")) {
            errorList.add(Services.getText(914));
        } else {
            errorList.add(AzaErrorHandler.getRuleErrorDescription(error));
        }
    }

    private GoodsDeclaration getGoodsDeclaration() {
        return this.sending.getGoodsDeclaration();
    }

    private boolean is(RuleErrorType.Error error, String ... ruleNames) {
        for (String current : ruleNames) {
            if (!error.getRuleName().equals(current)) continue;
            return true;
        }
        return false;
    }

    private GoodsItem getItem(RuleErrorType.Error error) {
        String traderItemId = error.getReference().replaceFirst("traderItemID:", "");
        for (GoodsItem current : this.sending.getCustomsItemListIfPresent().getGoodsItems()) {
            if (!current.getGoodsData().getTraderItemID().getStringValue().equals(traderItemId)) continue;
            return current;
        }
        throw Check.fail("GoodsItem not found: ", traderItemId);
    }

    private void setError(INode<?> node, RuleErrorType.Error error) {
        this.setError(node, error, AzaErrorHandler.getDescription(error));
    }

    private void setError(INode<?> node, RuleErrorType.Error error, String errorText) {
        ErrorMarker errorMarker = new ErrorMarker(error.getRuleName(), node, errorText + " (" + error.getRuleName() + ")");
        Services.get(IValidateService.class).addError(errorMarker);
    }

    private void handleSchemaError(XMLSchemaErrorType xmlSchemaErrors) {
        StringBuilder result = new StringBuilder("AZA Schema Error");
        result.append("\n");
        for (XMLSchemaErrorType.Error error : xmlSchemaErrors.getError()) {
            result.append(error.getMessage());
            result.append("\n");
        }
        Services.get(ILoggingService.class).logAndReport(result.toString());
    }
}

