/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.ezv.bordereau;

import ch.e_dec.services.edecbordereauservice.v1.BordereauRequestFault;
import ch.e_dec.xml.schema.edecbordereauresponse.v1.BordereauRequestRejectionType;
import ch.e_dec.xml.schema.edecbordereauresponse.v1.BordereauRequestResponse;
import ch.e_dec.xml.schema.edecbordereauresponse.v1.DescriptionType;
import ch.e_dec.xml.schema.edecbordereauresponse.v1.ErrorType;
import ch.e_dec.xml.schema.edecbordereauresponse.v1.RuleErrorType;
import ch.e_dec.xml.schema.edecbordereauresponse.v1.XMLSchemaErrorType;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.text.ITextService;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.ErrorUtil;
import java.util.ArrayList;
import java.util.List;

public class BordereauErrorHandler {
    private final BordereauRequestFault error;

    public BordereauErrorHandler(BordereauRequestFault error) {
        this.error = error;
        this.handleError();
    }

    private void handleError() {
        List<String> errors = this.createErrorList();
        ErrorUtil.showErrors("Error fetching Bordereau", errors);
    }

    public List<String> createErrorList() {
        BordereauRequestResponse rep = this.error.getFaultInfo();
        BordereauRequestRejectionType rejection = rep.getBordereauRequestRejection();
        BordereauRequestRejectionType.Errors errors = rejection.getErrors();
        if (errors.getXMLSchemaErrors() != null) {
            return this.handleSchemaErrors(errors.getXMLSchemaErrors());
        }
        if (errors.getRuleErrors() != null) {
            return this.handleRuleErrors(errors.getRuleErrors());
        }
        ArrayList<String> errorList = new ArrayList<String>();
        errorList.add("No Error found");
        return errorList;
    }

    private List<String> handleRuleErrors(RuleErrorType ruleErrors) {
        ArrayList<String> errorList = new ArrayList<String>();
        errorList.add("Bordereau Rule Error");
        if (ruleErrors != null) {
            for (RuleErrorType.Error error : ruleErrors.getError()) {
                errorList.add(BordereauErrorHandler.getRuleErrorDescription(error));
            }
        }
        return errorList;
    }

    private List<String> handleSchemaErrors(XMLSchemaErrorType xmlSchemaErrors) {
        ArrayList<String> errorList = new ArrayList<String>();
        errorList.add("Bordereau schema error");
        for (ErrorType error : xmlSchemaErrors.getError()) {
            errorList.add(error.getMessage());
        }
        return errorList;
    }

    public static String getRuleErrorDescription(RuleErrorType.Error error) {
        return BordereauErrorHandler.getDescription(error) + " (" + error.getRuleName() + ")";
    }

    private static String getDescription(RuleErrorType.Error error) {
        if (error.getRuleName().equals("R233")) {
            return Services.getText(914);
        }
        if (error.getRuleName().equals("v12")) {
            throw Check.fail("invalid date range for fetching Bordereau");
        }
        if (error.getRuleName().equals("b4")) {
            return Services.getText(645);
        }
        ITextService.Language language = Services.get(ITextService.class).getCurrentLanguage();
        List<DescriptionType.Description> descriptions = error.getDescriptions().getDescription();
        for (DescriptionType.Description current : descriptions) {
            if (!current.getLanguage().equals(language.name())) continue;
            return current.getContent();
        }
        if (descriptions.isEmpty()) {
            return Services.getText(915);
        }
        return descriptions.get(0).getContent();
    }
}

