/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.ezv.evv;

import ch.transsoft.edec.util.Check;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.handler.MessageContext;
import jakarta.xml.ws.handler.soap.SOAPHandler;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import java.io.ByteArrayOutputStream;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

public class ResponseFetchHandler
implements SOAPHandler<SOAPMessageContext> {
    private ByteArrayOutputStream os = new ByteArrayOutputStream();

    @Override
    public boolean handleMessage(SOAPMessageContext c2) {
        SOAPMessage msg = c2.getMessage();
        boolean request = (Boolean)c2.get("jakarta.xml.ws.handler.message.outbound");
        if (request) {
            return true;
        }
        try {
            this.repairMsg(msg);
        }
        catch (SOAPException e2) {
            Check.fail(e2, "failed to repair message");
        }
        try {
            msg.writeTo(this.os);
        }
        catch (Exception e3) {
            Check.fail(e3, "failed to write soap-message to stram");
        }
        return true;
    }

    private void repairMsg(SOAPMessage msg) throws SOAPException {
        msg.getSOAPHeader().addTextNode("\n").getClass();
        msg.getSOAPBody().insertBefore(this.createTextNode(msg, "\n  "), msg.getSOAPBody().getFirstChild());
        msg.getSOAPBody().addTextNode("\n ").getClass();
    }

    private Node createTextNode(SOAPMessage msg, String string) throws SOAPException {
        return msg.getSOAPBody().getOwnerDocument().createTextNode(string);
    }

    @Override
    public boolean handleFault(SOAPMessageContext c2) {
        return true;
    }

    @Override
    public void close(MessageContext c2) {
    }

    @Override
    public Set<QName> getHeaders() {
        return null;
    }

    public byte[] getSoapMessage() {
        return this.os.toByteArray();
    }
}

