/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.ezv.evv.sigcheck.validator;

import ch.transsoft.edec.service.ezv.evv.sigcheck.context.SystemContext;
import java.security.PublicKey;
import java.util.Iterator;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import org.w3c.dom.Node;

public class XMLSignatureValidator {
    private final PublicKey publicKey;
    private final SystemContext systemContext;

    public XMLSignatureValidator(SystemContext context, PublicKey publicKey) {
        this.publicKey = publicKey;
        this.systemContext = context;
    }

    public boolean isValid(Node dsSignature) {
        try {
            DOMValidateContext validateContext = new DOMValidateContext(this.publicKey, dsSignature);
            validateContext.setProperty("org.jcp.xml.dsig.secureValidation", Boolean.FALSE);
            XMLSignatureFactory factory = XMLSignatureFactory.getInstance("DOM", "XMLDSig");
            XMLSignature signature = factory.unmarshalXMLSignature(validateContext);
            boolean coreValidity = signature.validate(validateContext);
            if (!coreValidity) {
                boolean sv = signature.getSignatureValue().validate(validateContext);
                String status = sv ? "OK" : "NOT OK";
                this.systemContext.getOutputterStrategy().write("check signature value element: " + status);
                Iterator<Reference> i2 = signature.getSignedInfo().getReferences().iterator();
                int j2 = 0;
                while (i2.hasNext()) {
                    Reference ref = i2.next();
                    boolean refValid = ref.validate(validateContext);
                    String id = ref.getURI();
                    status = refValid ? "OK" : "NOT OK";
                    this.systemContext.getOutputterStrategy().write("check signature reference (" + j2 + ") with URI [" + id + "] validation status: " + status);
                    ++j2;
                }
            }
            return coreValidity;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            this.systemContext.getOutputterStrategy().write("signature error: " + e2.getMessage());
            return false;
        }
    }
}

