/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.form;

import ch.transsoft.edec.model.config.conf.printer.CorrectionData;
import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.itemlist.ItemList;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsItem;
import ch.transsoft.edec.service.form.IFormDesc;
import ch.transsoft.edec.service.form.IFormPageDesc;
import ch.transsoft.edec.service.form.PagePrintInfo;
import ch.transsoft.edec.service.form.render.DataContext;
import ch.transsoft.edec.service.form.render.IDataContext;
import ch.transsoft.edec.service.form.render.IRenderContext;
import ch.transsoft.edec.service.form.render.PrintDataContext;
import ch.transsoft.edec.ui.dialog.print.pm.IPagePrintJob;
import ch.transsoft.edec.ui.dialog.print.pm.PagePrintJob;
import ch.transsoft.edec.util.Check;
import java.util.ArrayList;
import java.util.List;

public abstract class FormBase
implements IFormDesc {
    private final List<IFormPageDesc> pageDescs = new ArrayList<IFormPageDesc>();
    private final Sending.FormName formName;

    public FormBase(Sending.FormName formName) {
        this.formName = formName;
    }

    @Override
    public List<IFormPageDesc> getFrontPages() {
        return this.pageDescs;
    }

    protected void add(IFormPageDesc pageDesc) {
        this.pageDescs.add(pageDesc);
    }

    @Override
    public List<IPagePrintJob> printPage(Sending sending, DataContext dataContext, IFormPageDesc desc, IRenderContext.Mode mode) {
        ArrayList<IPagePrintJob> result = new ArrayList<IPagePrintJob>();
        for (int i2 = 0; i2 < dataContext.getPageCount(); ++i2) {
            IPagePrintJob job = this.createPagePrintJob(sending, desc, new PrintDataContext(dataContext, i2 + 1), mode);
            result.add(job);
        }
        return result;
    }

    @Override
    public List<IPagePrintJob> printSimplex(Sending sending, DataContext dataContext, PagePrintInfo printInfo, IRenderContext.Mode mode) {
        int copies = printInfo.getPageDesc().getNumberOfCopies();
        ArrayList<IPagePrintJob> result = new ArrayList<IPagePrintJob>();
        for (int i2 = 0; i2 < dataContext.getPageCount(); ++i2) {
            for (int l2 = 0; l2 < copies; ++l2) {
                IPagePrintJob job = this.createPagePrintJob(sending, printInfo, new PrintDataContext(dataContext, i2 + 1), mode, l2 + 1);
                result.add(job);
            }
        }
        return result;
    }

    protected IPagePrintJob createEmptyPagePrintJob() {
        return g2 -> {};
    }

    protected IPagePrintJob createPagePrintJob(Sending sending, IFormPageDesc desc, IDataContext dataContext, IRenderContext.Mode mode) {
        CorrectionData defaultCorrection = NodeFactory.create(CorrectionData.class);
        return new PagePrintJob(sending, this.getGoodsItems(sending), desc, defaultCorrection, dataContext, mode, 1);
    }

    protected IPagePrintJob createPagePrintJob(Sending sending, PagePrintInfo pageInfo, IDataContext dataContext, IRenderContext.Mode mode, int copyNumber) {
        return new PagePrintJob(sending, this.getGoodsItems(sending), pageInfo.getPageDesc(), pageInfo.getCorrection(), dataContext, mode, copyNumber);
    }

    @Override
    public List<IPagePrintJob> printDuplex(Sending sending, DataContext dataContext, PagePrintInfo frontPageInfo, PagePrintInfo backPageInfo, IRenderContext.Mode mode) {
        throw Check.unsupportedOperation();
    }

    @Override
    public IFormPageDesc getBackPage() {
        return null;
    }

    @Override
    public String getDuplexName() {
        throw Check.unsupportedOperation();
    }

    @Override
    public int getDefaultNumber() {
        return 1;
    }

    @Override
    public IFormPageDesc getFrontPage(Sending sending) {
        int index = sending.getForms().getSelectedVariantIndex(this, this.getFrontPages());
        return this.getFrontPages().get(index);
    }

    @Override
    public int getNumberOfUnits(int numberOfCopies, Sending sending, DataContext dataContext) {
        int partsCount = dataContext.getPageCount();
        return numberOfCopies * partsCount;
    }

    @Override
    public DataContext createDataContext(Sending sending) {
        return this.createDataContext(sending, this.getFrontPage(sending));
    }

    @Override
    public DataContext createDataContext(Sending sending, IFormPageDesc formPageDesc) {
        return new DataContext(this.getGoodsItems(sending), formPageDesc);
    }

    @Override
    public ItemList getGoodsItems(Sending sending) {
        return sending.getItemListForForm(this.formName);
    }

    @Override
    public String getName(Sending sending) {
        return this.getName();
    }

    protected boolean hasBgLetter(GoodsItem goodsItem) {
        return !goodsItem.getGoodsData().getBgLetter().getValue().isEmpty();
    }

    @Override
    public boolean hasBackPage() {
        return this.getBackPage() != null;
    }
}

