/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.form;

import ch.transsoft.edec.service.form.IFormDesc;
import ch.transsoft.edec.service.form.IFormPageDesc;
import ch.transsoft.edec.service.form.IFormService;
import ch.transsoft.edec.service.form.forms.bg.BG;
import ch.transsoft.edec.service.form.forms.bill.BillDesc;
import ch.transsoft.edec.service.form.forms.cmr.Cmr;
import ch.transsoft.edec.service.form.forms.deliverynote.DeliveryNoteDesc;
import ch.transsoft.edec.service.form.forms.emergency.Emergency;
import ch.transsoft.edec.service.form.forms.eur1.Eur1;
import ch.transsoft.edec.service.form.forms.list.ItemListForm;
import ch.transsoft.edec.service.form.forms.spedi.Spedi;
import ch.transsoft.edec.service.form.forms.uz.UZ;
import ch.transsoft.edec.util.Check;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FormService
implements IFormService {
    ArrayList<IFormDesc> screenOrder = new ArrayList();
    ArrayList<IFormDesc> printOrder = new ArrayList();

    public FormService() {
        this.screenOrder.add(new Spedi());
        this.screenOrder.add(new Eur1());
        this.screenOrder.add(new BillDesc());
        this.screenOrder.add(new DeliveryNoteDesc());
        this.screenOrder.add(new UZ());
        this.screenOrder.add(new BG());
        this.screenOrder.add(new Cmr());
        this.screenOrder.add(new ItemListForm());
        this.screenOrder.add(new Emergency());
        this.checkForms(this.screenOrder);
        this.printOrder.add(new Eur1());
        this.printOrder.add(new UZ());
        this.printOrder.add(new BG());
        this.printOrder.add(new BillDesc());
        this.printOrder.add(new DeliveryNoteDesc());
        this.printOrder.add(new Spedi());
        this.printOrder.add(new Cmr());
        this.printOrder.add(new ItemListForm());
        this.printOrder.add(new Emergency());
    }

    private void checkForms(ArrayList<IFormDesc> forms) {
        HashSet<String> pageIds = new HashSet<String>();
        for (IFormDesc form : forms) {
            ArrayList<IFormPageDesc> pages = new ArrayList<IFormPageDesc>(form.getFrontPages());
            IFormPageDesc backPage = form.getBackPage();
            if (backPage != null) {
                pages.add(backPage);
            }
            this.checkPages(pageIds, pages);
        }
    }

    private void checkPages(Set<String> pageIds, List<IFormPageDesc> pages) {
        for (IFormPageDesc page : pages) {
            Check.assertTrue(pageIds.add(page.getId()), "pageId collision: " + page.getId());
        }
    }

    @Override
    public List<IFormDesc> getFormsInPrintOrder() {
        return this.printOrder;
    }

    @Override
    public List<IFormDesc> getForms() {
        return this.screenOrder;
    }
}

