/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.form.desc;

import ch.transsoft.edec.model.infra.annotation.decimalSpec;
import ch.transsoft.edec.model.infra.annotation.defaultValue;
import ch.transsoft.edec.model.infra.annotation.enumType;
import ch.transsoft.edec.model.infra.annotation.mandatory;
import ch.transsoft.edec.model.infra.node.BooleanNode;
import ch.transsoft.edec.model.infra.node.DecimalNode;
import ch.transsoft.edec.model.infra.node.EnumNode;
import ch.transsoft.edec.model.infra.node.INode;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.infra.node.ListEntry;
import ch.transsoft.edec.model.infra.node.SelectionNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.sending.itemlist.ItemList;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsItem;
import ch.transsoft.edec.service.form.desc.Fonts;
import ch.transsoft.edec.service.form.desc.ITextDesc;
import ch.transsoft.edec.service.form.desc.TextStrategy;
import ch.transsoft.edec.util.Check;

public final class GoodsItemDesc
extends ListEntry<GoodsItemDesc>
implements ITextDesc {
    private StringNode nodePath;
    @decimalSpec(totalDigits=10, fractionDigits=1)
    @defaultValue(value="0")
    private DecimalNode x;
    @decimalSpec(totalDigits=10, fractionDigits=1)
    @defaultValue(value="0")
    private DecimalNode y;
    @decimalSpec(totalDigits=10, fractionDigits=1)
    @defaultValue(value="50")
    private DecimalNode width;
    @decimalSpec(totalDigits=10, fractionDigits=1)
    @defaultValue(value="1")
    private IntegralNode height;
    @enumType(value=TextStrategy.class)
    @defaultValue(value="none")
    private EnumNode<TextStrategy> textStrategy;
    @enumType(value=Fonts.class)
    @defaultValue(value="font10")
    private EnumNode<Fonts> font;
    @mandatory
    @defaultValue(value="true")
    private BooleanNode editable;
    @mandatory
    @defaultValue(value="false")
    private BooleanNode carryover;
    @mandatory
    @defaultValue(value="false")
    private BooleanNode alignRight;
    @mandatory
    @defaultValue(value="false")
    private BooleanNode descOnly;
    @mandatory
    @defaultValue(value="false")
    private BooleanNode keyOnly;

    @Override
    public DecimalNode getX() {
        return this.x;
    }

    @Override
    public DecimalNode getY() {
        return this.y;
    }

    @Override
    public DecimalNode getWidth() {
        return this.width;
    }

    @Override
    public IntegralNode getHeight() {
        return this.height;
    }

    public EnumNode<TextStrategy> getTextStrategy() {
        return this.textStrategy;
    }

    public EnumNode<Fonts> getFont() {
        return this.font;
    }

    public StringNode getNodePath() {
        return this.nodePath;
    }

    public BooleanNode getIsEditable() {
        return this.editable;
    }

    public String getTextValue(ItemList goodsItems, int pos, boolean descOnly, boolean keyOnly) {
        if (this.getNodePath().getValue().equals("pos")) {
            return Integer.toString(pos + 1);
        }
        INode<?> result = this.getPrimitive(goodsItems, pos);
        if (result instanceof SelectionNode) {
            if (descOnly) {
                return ((SelectionNode)result).getValue().getDesc();
            }
            if (keyOnly) {
                return ((SelectionNode)result).getValue().getKey();
            }
        }
        return result.toString();
    }

    public INode<?> getPrimitive(ItemList goodsItems, int pos) {
        GoodsItem goodsItem = goodsItems.getGoodsItems().get(pos);
        return goodsItem.find(this.getNodePath().getValue());
    }

    @Override
    public TextStrategy getTextStrategyValue() {
        return this.getTextStrategy().getValue();
    }

    @Override
    public boolean splitAtWhitespace() {
        return true;
    }

    @Override
    public boolean isEditable() {
        return this.getIsEditable().getValue();
    }

    public BooleanNode getEditable() {
        return this.editable;
    }

    public BooleanNode getCarryover() {
        return this.carryover;
    }

    public BooleanNode getAlignRight() {
        return this.alignRight;
    }

    public BooleanNode getDescOnly() {
        return this.descOnly;
    }

    public BooleanNode getKeyOnly() {
        return this.keyOnly;
    }

    public String getSum(ItemList goodsItems, int from, int to) {
        Check.assertTrue(to > from && to <= goodsItems.size(), "invalid range[", from, ",", to, "]");
        DecimalNode first = (DecimalNode)this.getPrimitive(goodsItems, from);
        DecimalNode result = new DecimalNode(0.0, first.getTotalDigits(), first.getFractionDigits());
        for (int i2 = from; i2 < to; ++i2) {
            result.add((DecimalNode)this.getPrimitive(goodsItems, i2));
        }
        return result.toString();
    }

    @Override
    public Fonts getFontValue() {
        return this.getFont().getValue();
    }

    @Override
    public int getLineExtensionPx() {
        return 0;
    }
}

