/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.form.desc;

import ch.transsoft.edec.model.infra.annotation.decimalSpec;
import ch.transsoft.edec.model.infra.annotation.defaultValue;
import ch.transsoft.edec.model.infra.annotation.enumType;
import ch.transsoft.edec.model.infra.annotation.mandatory;
import ch.transsoft.edec.model.infra.node.BooleanNode;
import ch.transsoft.edec.model.infra.node.DecimalNode;
import ch.transsoft.edec.model.infra.node.EnumNode;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.infra.node.ListEntry;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.form.desc.Fonts;
import ch.transsoft.edec.service.form.desc.ITextDesc;
import ch.transsoft.edec.service.form.desc.TextStrategy;

public final class LabelDesc
extends ListEntry<LabelDesc>
implements ITextDesc {
    private StringNode text;
    private IntegralNode textId;
    @decimalSpec(totalDigits=10, fractionDigits=1)
    @defaultValue(value="0")
    private DecimalNode x;
    @decimalSpec(totalDigits=10, fractionDigits=1)
    @defaultValue(value="0")
    private DecimalNode y;
    @decimalSpec(totalDigits=10, fractionDigits=1)
    @defaultValue(value="50")
    private DecimalNode width;
    @decimalSpec(totalDigits=10, fractionDigits=1)
    @defaultValue(value="1")
    private IntegralNode height;
    @enumType(value=TextStrategy.class)
    @defaultValue(value="none")
    private EnumNode<TextStrategy> textStrategy;
    @enumType(value=Fonts.class)
    @defaultValue(value="font10")
    private EnumNode<Fonts> font;
    @defaultValue(value="false")
    private BooleanNode alignRight;
    @mandatory
    private BooleanNode suppressPrint;
    private StringNode depends;

    @Override
    public DecimalNode getX() {
        return this.x;
    }

    @Override
    public DecimalNode getY() {
        return this.y;
    }

    @Override
    public DecimalNode getWidth() {
        return this.width;
    }

    @Override
    public IntegralNode getHeight() {
        return this.height;
    }

    public IntegralNode getTextId() {
        return this.textId;
    }

    public EnumNode<TextStrategy> getTextStrategy() {
        return this.textStrategy;
    }

    public StringNode getText() {
        return this.text;
    }

    public EnumNode<Fonts> getFont() {
        return this.font;
    }

    public String getLabelText() {
        if (this.text.isInitialized()) {
            return this.text.getValue();
        }
        if (!this.textId.isInitialized()) {
            return "no text";
        }
        return Services.getText(this.textId.getIntValue());
    }

    public String getTextValue(Sending sending) {
        return this.getLabelText();
    }

    @Override
    public TextStrategy getTextStrategyValue() {
        return this.getTextStrategy().getValue();
    }

    @Override
    public boolean splitAtWhitespace() {
        return true;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public Fonts getFontValue() {
        return this.getFont().getValue();
    }

    public BooleanNode getSuppressPrint() {
        return this.suppressPrint;
    }

    public StringNode getDepends() {
        return this.depends;
    }

    @Override
    public int getLineExtensionPx() {
        return 0;
    }

    public BooleanNode getAlignRight() {
        return this.alignRight;
    }
}

