/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.form.editor.gui.controls;

import ch.transsoft.edec.model.infra.event.IChangeInfo;
import ch.transsoft.edec.model.infra.event.IChangeListener;
import ch.transsoft.edec.model.infra.node.DecimalNode;
import ch.transsoft.edec.model.infra.node.INode;
import ch.transsoft.edec.service.form.editor.gui.controls.InputField;
import ch.transsoft.edec.util.NumberUtil;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class DecimalField
extends InputField
implements IChangeListener {
    private final DecimalNode node;

    public DecimalField(DecimalNode node) {
        super(node);
        this.node = node;
        this.setText();
        node.addChangeListener(this);
    }

    @Override
    protected void save() {
        try {
            double value = Double.parseDouble(this.getText());
            this.node.setValue(value);
        }
        catch (NumberFormatException e2) {
            this.setText();
        }
    }

    @Override
    public void changed(INode<?> source, IChangeInfo info) {
        this.setText();
    }

    private void setText() {
        DecimalFormat format = NumberUtil.createNumberFormat();
        ((NumberFormat)format).setMaximumFractionDigits(1);
        this.setText(format.format(this.node.getValue()));
    }
}

