/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.form.editor.gui.node;

import ch.transsoft.edec.service.form.desc.FormPageDesc;
import ch.transsoft.edec.service.form.desc.NodeDesc;
import ch.transsoft.edec.service.form.editor.gui.controls.Element;
import ch.transsoft.edec.service.form.editor.gui.node.NodeEditor;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class NodeControl
extends Element {
    private final NodeDesc desc;
    private JLabel result;
    private static final Border border = new LineBorder(Color.GRAY, 1);

    public NodeControl(NodeDesc desc) {
        this.desc = desc;
        desc.addChangeListener((source, info) -> this.setState());
    }

    @Override
    public JComponent createComponent() {
        this.result = new JLabel();
        this.setState();
        this.result.setOpaque(true);
        this.result.setBackground(new Color(100, 100, 100, 50));
        this.result.setBorder(border);
        return this.result;
    }

    private void setState() {
        this.result.setText(this.desc.getNodePath().getStringValue());
        this.result.setToolTipText(this.desc.getNodePath().getStringValue());
        this.result.setFont(this.unitConverter.getFont(this.desc.getFontValue()));
        this.setSize(this.result);
    }

    @Override
    public JPanel getEditor() {
        return new NodeEditor(this.desc);
    }

    @Override
    public void setHasFocus(boolean value) {
        if (value) {
            this.result.setBorder(new LineBorder(Color.RED, 1));
        } else {
            this.result.setBorder(border);
        }
        if (this.result.getParent() != null) {
            this.result.getParent().repaint();
        }
    }

    @Override
    public int getHeight() {
        return this.desc.getHeight().getIntValue() * (this.unitConverter.getFont(this.desc.getFontValue()).getSize() + 5);
    }

    @Override
    public int getWidth() {
        return this.scale(this.desc.getWidth());
    }

    @Override
    public int getX() {
        return this.scale(this.desc.getX());
    }

    @Override
    public int getY() {
        return this.scale(this.desc.getY());
    }

    @Override
    public void remove(FormPageDesc formPageDesc) {
        formPageDesc.getNodes().remove(this.desc);
    }

    @Override
    public void setX(int px) {
        this.desc.getX().setValue(this.unitConverter.mmx(px));
    }

    @Override
    public void setY(int py) {
        this.desc.getY().setValue(this.unitConverter.mmy(py));
    }
}

