/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.form.editor.model;

import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.infra.XMLReader;
import ch.transsoft.edec.model.infra.XMLWriter;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.service.form.IFormPageDesc;
import ch.transsoft.edec.service.form.desc.FormPageDesc;
import ch.transsoft.edec.service.form.desc.GoodsItemDesc;
import ch.transsoft.edec.service.form.desc.LabelDesc;
import ch.transsoft.edec.service.form.desc.LineDesc;
import ch.transsoft.edec.service.form.desc.NodeDesc;
import ch.transsoft.edec.service.form.editor.gui.CenterPanel;
import ch.transsoft.edec.service.form.editor.gui.controls.IElement;
import ch.transsoft.edec.service.form.editor.gui.goodsitem.GoodsItemControl;
import ch.transsoft.edec.service.form.editor.gui.label.LabelControl;
import ch.transsoft.edec.service.form.editor.gui.line.LineControl;
import ch.transsoft.edec.service.form.editor.gui.node.NodeControl;
import ch.transsoft.edec.service.form.editor.model.IEditorModelListener;
import ch.transsoft.edec.ui.gui.sending.forms.UnitConverterFactory;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.disposable.IDisposable;
import ch.transsoft.edec.util.disposable.ListenerList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;

public class EditorModel {
    private final FormPageDesc desc;
    private final ListenerList<IEditorModelListener> listeners = new ListenerList();
    private IElement selection;
    private final IFormPageDesc formSide;
    private final List<IElement> elements = new ArrayList<IElement>();

    public EditorModel(IFormPageDesc formSide) {
        this.formSide = formSide;
        this.desc = this.loadDesc();
        this.createElements();
    }

    private void createElements() {
        this.addLabels(this.desc.getLabels());
        this.addNodes(this.desc.getNodes());
        this.addGoodsItems(this.desc.getGoodsItems());
        this.addLines(this.desc.getLines());
    }

    private void addLines(ListNode<LineDesc> lines) {
        for (LineDesc desc : lines) {
            this.elements.add(new LineControl(desc));
        }
    }

    private void addLabels(ListNode<LabelDesc> labels) {
        for (LabelDesc desc : labels) {
            this.elements.add(new LabelControl(desc));
        }
    }

    private void addNodes(ListNode<NodeDesc> nodes) {
        for (NodeDesc desc : nodes) {
            this.elements.add(new NodeControl(desc));
        }
    }

    private void addGoodsItems(ListNode<GoodsItemDesc> nodes) {
        for (GoodsItemDesc desc : nodes) {
            this.elements.add(new GoodsItemControl(desc));
        }
    }

    public Iterable<IElement> getElements() {
        return this.elements;
    }

    private FormPageDesc loadDesc() {
        File desc = new File(this.getDescFilePath());
        if (!desc.exists()) {
            return NodeFactory.create(FormPageDesc.class);
        }
        XMLReader reader = new XMLReader();
        try {
            FormPageDesc result = reader.read(new FileInputStream(desc), FormPageDesc.class);
            result.clearPendingChanges();
            return result;
        }
        catch (Exception e2) {
            return NodeFactory.create(FormPageDesc.class);
        }
    }

    private String getDescFilePath() {
        return this.formSide.getDescUrl().getFile().replace("build/resources/main/", "resources/").replace("out/production/", "");
    }

    public boolean hasPendingChanges() {
        return this.desc.hasPendingChanges();
    }

    public void save() {
        XMLWriter writer = new XMLWriter();
        try {
            writer.write(new FileOutputStream(this.getDescFilePath()), this.desc);
        }
        catch (Exception e2) {
            Check.fail(e2);
        }
        this.desc.clearPendingChanges();
    }

    public void triggerSelectionChanged(IElement element) {
        if (this.selection != null) {
            this.selection.setHasFocus(false);
        }
        this.selection = element;
        if (this.selection != null) {
            this.selection.setHasFocus(true);
        }
        for (IEditorModelListener listener : this.listeners) {
            listener.selected(this.selection);
        }
    }

    public IDisposable add(IEditorModelListener listener) {
        return this.listeners.add(listener);
    }

    public FormPageDesc getDesc() {
        return this.desc;
    }

    private void triggerAdded(IElement element) {
        for (IEditorModelListener listener : this.listeners) {
            listener.added(element);
        }
    }

    private void triggerRemoved(IElement element) {
        for (IEditorModelListener listener : this.listeners) {
            listener.removed(element);
        }
    }

    public void addLabel() {
        LabelDesc create = NodeFactory.create(LabelDesc.class);
        this.desc.getLabels().add(create);
        this.triggerAdded(new LabelControl(create));
    }

    public void addNode() {
        NodeDesc create = NodeFactory.create(NodeDesc.class);
        this.desc.getNodes().add(create);
        this.triggerAdded(new NodeControl(create));
    }

    public void addGoodsItem() {
        GoodsItemDesc create = NodeFactory.create(GoodsItemDesc.class);
        this.desc.getGoodsItems().add(create);
        this.triggerAdded(new GoodsItemControl(create));
    }

    public void addLine() {
        LineDesc create = NodeFactory.create(LineDesc.class);
        this.desc.getLines().add(create);
        this.triggerAdded(new LineControl(create));
    }

    public void delete() {
        if (this.selection == null) {
            return;
        }
        this.selection.remove(this.desc);
        this.triggerRemoved(this.selection);
        this.selection = null;
        this.triggerSelectionChanged(null);
    }

    public void addStaticControls(CenterPanel centerPanel) {
        this.formSide.addStaticControls(centerPanel, UnitConverterFactory.createFormEditorConverter());
    }
}

