/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.form.forms.bg;

import ch.transsoft.edec.model.infra.node.StringNodeBase;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.forms.BG;
import ch.transsoft.edec.model.sending.itemlist.ItemList;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.form.desc.Fonts;
import ch.transsoft.edec.service.form.forms.bg.BgBase;
import ch.transsoft.edec.service.form.forms.uz.ChamberTexts;
import ch.transsoft.edec.service.form.render.IDataContext;
import ch.transsoft.edec.service.form.render.IRenderContext;
import ch.transsoft.edec.service.form.render.IUnitConverter;
import ch.transsoft.edec.service.masterdataezv.DomainValue;
import ch.transsoft.edec.ui.gui.control.StringField;
import ch.transsoft.edec.ui.gui.sending.forms.PageContentPanel;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.ui.pm.model.StringPm;
import ch.transsoft.edec.util.disposable.Disposables;
import java.awt.Color;
import java.net.URL;
import javax.swing.ImageIcon;

public class BGBack
extends BgBase {
    @Override
    public URL getDescUrl() {
        return this.getClass().getResource("bg_back.xml");
    }

    @Override
    public String getPrintName() {
        return Services.getText(705);
    }

    @Override
    public String getGuiName() {
        return Services.getText(706);
    }

    @Override
    public String getId() {
        return "bg_back";
    }

    @Override
    public double getLineHeight() {
        return 4.0;
    }

    @Override
    public int getLinesPerPage() {
        return 14;
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.getIcon("icon/forms/bg.png");
    }

    @Override
    public void addControls(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2) {
        this.addExplanationFields(disposables, sending, panel, c2);
    }

    private void addExplanationFields(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2) {
        this.addTextField(disposables, sending, panel, c2, 20.0, sending.getForms().getBg().getBackExplanation1());
        this.addTextField(disposables, sending, panel, c2, 60.0, sending.getForms().getBg().getBackExplanation2());
        this.addTextField(disposables, sending, panel, c2, 100.0, sending.getForms().getBg().getBackExplanation3());
        this.addTextField(disposables, sending, panel, c2, 140.0, sending.getForms().getBg().getBackExplanation4());
    }

    private void addTextField(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2, double x, StringNodeBase<?> stringNode) {
        StringPm pm = new StringPm(stringNode);
        disposables.add(pm);
        StringField text = new StringField(pm);
        text.setFont(c2.getFont(Fonts.font8));
        text.setBounds(c2.px(x), c2.py(180.0), c2.px(35.0), c2.py(5.0));
        panel.add(text);
    }

    @Override
    public void render(Sending sending, ItemList goodsItems, IDataContext dataContext, IRenderContext renderContext) {
        this.renderFieldDescs(sending, renderContext);
        this.renderText(sending, renderContext);
    }

    private void renderText(Sending sending, IRenderContext c2) {
        String text = this.createText(sending);
        c2.drawStringWrap(20.0, 165.0, 175.0, Fonts.font8, Color.BLACK, text);
    }

    private String createText(Sending sending) {
        BG bg = sending.getForms().getBg();
        StringBuilder result = new StringBuilder();
        result.append(this.getText(sending, 11087));
        result.append(bg.getBackExplanation1().getValue());
        result.append(this.getText(sending, 11088));
        result.append(bg.getBackExplanation2().getValue());
        result.append(this.getText(sending, 11089));
        result.append(bg.getBackExplanation3().getValue());
        result.append(this.getText(sending, 11090));
        DomainValue chamber = sending.getForms().getUz().getChamgerOfCommerceChooser().getValue();
        if (chamber.isInitialized()) {
            result.append(ChamberTexts.getText(chamber, 11));
        }
        result.append(this.getText(sending, 11091));
        result.append(bg.getBackExplanation4().getValue());
        result.append(this.getText(sending, 11092));
        return result.toString();
    }

    private void renderFieldDescs(Sending sending, IRenderContext c2) {
        this.render(sending, c2, 15.0, 10.0, Fonts.font14bold, 11070);
        this.render(c2, 15.0, 19.0, Fonts.font8bold, "1.");
        this.render(sending, c2, 20.0, 19.0, Fonts.font8bold, 11071);
        this.render(sending, c2, 20.0, 25.0, Fonts.font8, 11072, 11073, 11074, 11075, 11106);
        this.render(c2, 15.0, 45.0, Fonts.font8bold, "2.");
        this.render(sending, c2, 20.0, 45.0, Fonts.font8bold, 11076);
        this.render(sending, c2, 20.0, 51.0, Fonts.font8, 11077, 11078);
        this.render(sending, c2, 15.0, 70.0, Fonts.font6bold, 11079);
        this.render(sending, c2, 90.0, 70.0, Fonts.font6bold, 11080, 11081, 11082);
        this.render(sending, c2, 130.0, 70.0, Fonts.font6bold, 11083);
        this.render(sending, c2, 15.0, 131.0, Fonts.font6bold, 11084, 11085);
        this.render(c2, 15.0, 160.0, Fonts.font8bold, "3.");
        this.render(sending, c2, 20.0, 160.0, Fonts.font8bold, 11086);
        this.render(c2, 15.0, 185.0, Fonts.font8bold, "4.");
        this.render(sending, c2, 20.0, 185.0, Fonts.font8, 11093, 11094, 11095, 11096, 11097, 11098);
        this.render(sending, c2, 20.0, 206.0, Fonts.font8, 11099, 11100);
        this.render(sending, c2, 20.0, 220.0, Fonts.font8bold, 11101);
        this.render(sending, c2, 20.0, 226.0, Fonts.font8, 11102, 11103);
        this.render(sending, c2, 20.0, 240.0, Fonts.font8, 11104, 11105);
    }
}

