/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.form.forms.bg;

import ch.transsoft.edec.model.infra.AddressRenderer;
import ch.transsoft.edec.model.infra.node.BooleanNode;
import ch.transsoft.edec.model.infra.node.DecimalNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.itemlist.ItemList;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.form.desc.Fonts;
import ch.transsoft.edec.service.form.editor.gui.controls.BooleanField;
import ch.transsoft.edec.service.form.forms.bg.BgBase;
import ch.transsoft.edec.service.form.forms.uz.ChamberTexts;
import ch.transsoft.edec.service.form.render.IDataContext;
import ch.transsoft.edec.service.form.render.IRenderContext;
import ch.transsoft.edec.service.form.render.IUnitConverter;
import ch.transsoft.edec.service.masterdataezv.DomainValue;
import ch.transsoft.edec.ui.gui.control.StringField;
import ch.transsoft.edec.ui.gui.sending.forms.PageContentPanel;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.ui.pm.model.SelectionPm;
import ch.transsoft.edec.ui.pm.model.StringPm;
import ch.transsoft.edec.util.disposable.Disposables;
import java.awt.Color;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JRadioButton;

public class BGFront
extends BgBase {
    public static final Color BG_COLOR = new Color(255, 250, 150);
    public static final Fonts FONT1 = Fonts.font8;
    private static final int ROW_LIMIT_FOR_FREE_TEXT = 7;
    private static final int FREE_TEXT_X = 16;
    private static final int FREE_TEXT_Y = 161;
    private static final int FREE_TEXT_WIDTH = 120;
    private StringField referenceText;
    private StringPm referencePm;
    private StringPm declarantNamePm;
    private StringField telText;
    private StringPm telPm;
    private StringPm declarantPhonePm;

    @Override
    public URL getDescUrl() {
        return this.getClass().getResource("bg_front.xml");
    }

    @Override
    public String getPrintName() {
        return Services.getText(707);
    }

    @Override
    public String getGuiName() {
        return Services.getText(708);
    }

    @Override
    public String getId() {
        return "bg_front";
    }

    @Override
    public double getLineHeight() {
        return 4.0;
    }

    @Override
    public int getLinesPerPage() {
        return 14;
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.getIcon("icon/forms/bg.png");
    }

    @Override
    public void addControls(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2) {
        this.addChooseConsigneeAddressMode(sending, panel, c2, disposables);
        this.addChamberOfCommerceChooser(disposables, sending, panel, c2);
        this.addPrintInfo(panel, c2);
        this.addCheckboxForItemDescriptionLanguageSelection(panel, c2, sending, disposables);
        this.addReferenceControls(disposables, sending, panel, c2);
    }

    private void addChooseConsigneeAddressMode(Sending sending, PageContentPanel panel, IUnitConverter c2, Disposables disposables) {
        ButtonGroup radioGroup = new ButtonGroup();
        JRadioButton mode1 = this.addRadioButton(panel, c2, radioGroup, 70.0, 66.0, Services.getText(788));
        JRadioButton mode2 = this.addRadioButton(panel, c2, radioGroup, 70.0, 71.0, Services.getText(789));
        this.connectRadio(disposables, null, sending.getForms().getBg().getConsigneeAddressMode(), mode1, mode2);
    }

    private void addReferenceControls(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2) {
        this.referencePm = new StringPm(sending.getForms().getBg().getRef());
        disposables.add(this.referencePm);
        this.declarantNamePm = new StringPm(sending.getGoodsDeclaration().getDeclarant().getDeclarantName());
        disposables.add(this.declarantNamePm);
        this.referenceText = new StringField();
        this.referenceText.setFont(c2.getFont(Fonts.font9));
        this.referenceText.setBounds(c2.px(139.0), c2.py(243.5), c2.px(59.0), c2.py(5.0));
        panel.add(this.referenceText);
        this.telPm = new StringPm(sending.getForms().getBg().getTel());
        disposables.add(this.telPm);
        this.declarantPhonePm = new StringPm(sending.getGoodsDeclaration().getDeclarant().getPhone());
        disposables.add(this.declarantPhonePm);
        this.telText = new StringField();
        this.telText.setFont(c2.getFont(Fonts.font9));
        panel.add(this.telText);
        this.telText.setBounds(c2.px(139.0), c2.py(250.5), c2.px(59.0), c2.py(5.0));
        BooleanNode declarantAsReference = sending.getForms().getBg().getDeclarantAsReference();
        BooleanField checkbox = this.addCheckBox(disposables, panel, c2, "", declarantAsReference, 200.0, 243.5);
        checkbox.setToolTipText("Deklarant Name und Telefon aus Kopfdaten verwenden");
        disposables.add(declarantAsReference.addChangeListener((source, info) -> this.updateReference(sending)));
        this.updateReference(sending);
    }

    private void updateReference(Sending sending) {
        if (sending.getForms().getBg().getDeclarantAsReference().getValue().booleanValue()) {
            this.referenceText.setModel(this.declarantNamePm);
            this.referenceText.setReadOnly(true);
            this.telText.setModel(this.declarantPhonePm);
            this.telText.setReadOnly(true);
        } else {
            this.referenceText.setModel(this.referencePm);
            this.referenceText.setReadOnly(false);
            this.telText.setModel(this.telPm);
            this.telText.setReadOnly(false);
        }
    }

    private void addCheckboxForItemDescriptionLanguageSelection(PageContentPanel panel, IUnitConverter c2, Sending sending, Disposables disposables) {
        BooleanNode node = sending.getForms().getBg().getDescriptionInEnglish();
        this.addCheckBox(disposables, panel, c2, Services.getText(889), node, 56.0, 125.0);
    }

    private void addPrintInfo(PageContentPanel panel, IUnitConverter c2) {
        this.addInfoIcon(panel, c2, 167, true, 105.0, 4.5, 16);
    }

    private void addChamberOfCommerceChooser(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2) {
        SelectionPm pm = new SelectionPm(sending.getForms().getUz().getChamgerOfCommerceChooser());
        disposables.add(pm);
        this.addSelectionField(panel, pm, c2, 10.0, 3.0, 20.0, 5.0);
    }

    @Override
    public void render(Sending sending, ItemList goodsItems, IDataContext dataContext, IRenderContext renderContext) {
        this.renderFreeTextField(sending, dataContext, renderContext);
        this.renderConsignor(sending, renderContext);
        this.renderConsignee(sending, renderContext);
        this.renderTotals(sending, dataContext, renderContext);
        this.renderFieldDescs(sending, renderContext);
        this.renderChamberAddress(sending, renderContext);
        this.renderReference(sending, renderContext);
    }

    private void renderReference(Sending sending, IRenderContext renderContext) {
        BooleanNode declarantAsReference = sending.getForms().getBg().getDeclarantAsReference();
        String reference = declarantAsReference.getValue() != false ? sending.getGoodsDeclaration().getDeclarant().getDeclarantName().getValue() : sending.getForms().getBg().getRef().getValue();
        renderContext.drawString(139.0, 243.5, Fonts.font9, Color.BLACK, reference);
        String tel = declarantAsReference.getValue() != false ? sending.getGoodsDeclaration().getDeclarant().getPhone().getValue() : sending.getForms().getBg().getTel().getValue();
        renderContext.drawString(139.0, 250.5, Fonts.font9, Color.BLACK, tel);
    }

    private void renderChamberAddress(Sending sending, IRenderContext c2) {
        DomainValue value = sending.getForms().getUz().getChamgerOfCommerceChooser().getValue();
        if (!value.isInitialized()) {
            return;
        }
        String[] lines = new String[5];
        for (int i2 = 0; i2 < 5; ++i2) {
            lines[i2] = ChamberTexts.getText(value, i2 + 5);
        }
        c2.drawString(103.0, 42.0, Fonts.font7bold, Color.BLACK, lines);
        String openHours = ChamberTexts.getText(value, 10);
        if (!openHours.isEmpty()) {
            c2.drawString(103.0, 58.5, Fonts.font6, Color.BLACK, this.getText(sending, 11061));
            c2.drawString(103.0, 61.5, Fonts.font6, Color.BLACK, openHours);
        }
    }

    private void renderFieldDescs(Sending sending, IRenderContext c2) {
        this.render(sending, c2, 11.0, 10.0, FONT1, Fonts.font6, 11001, 11002);
        this.render(sending, c2, 11.0, 37.0, FONT1, 11003);
        this.render(sending, c2, 11.0, 85.0, FONT1, Fonts.font6, 11004, 11005);
        this.render(sending, c2, 11.0, 120.0, FONT1, 11006);
        this.render(sending, c2, 117.0, 120.0, FONT1, 11007, 11008, 11009);
        this.render(c2, 150.0, 120.0, FONT1, this.getText(sending, 11010), this.format(sending, 11011, "kg, l, m\u00b3"));
        this.render(sending, c2, 175.0, 120.0, FONT1, 11012, 11013);
        this.render(sending, c2, 175.0, 195.0, FONT1, 11014, 11015);
        this.render(sending, c2, 150.0, 195.0, FONT1, 11016);
        this.render(sending, c2, 103.0, 32.0, Fonts.font7, 11017, 11018, 11019);
        this.render(sending, c2, 103.0, 65.0, Fonts.font8bold, 11020);
        this.render(sending, c2, 103.0, 85.0, Fonts.font8bold, 11021);
        this.render(sending, c2, 115.0, 214.5, Fonts.font8bold, 11022, 11023, 11024);
        this.render(sending, c2, 115.0, 226.5, Fonts.font8bold, 11025, 11026);
        this.render(sending, c2, 115.0, 237.0, Fonts.font8, 11027);
        this.render(sending, c2, 115.0, 244.0, Fonts.font8, 11028);
        this.render(sending, c2, 115.0, 251.0, Fonts.font8, 11029);
        this.renderCenter(sending, c2, 102.0, 27.0, 97.0, Fonts.font14bold, 11030);
        this.render(sending, c2, 116.0, 259.0, Fonts.font8, 11031, 11032);
        this.render(sending, c2, 11.0, 213.5, Fonts.font10bold, Fonts.font6, 11040, 11041);
        this.render(sending, c2, 11.0, 218.5, Fonts.font6, 11042);
        this.render(sending, c2, 11.0, 224.5, Fonts.font8bold, 11043);
        this.render(sending, c2, 15.0, 228.0, Fonts.font7, 11044, 11045, 11046, 11047, 11048, 11049, 11050);
        this.render(c2, 11.0, 228.0, Fonts.font7bold, "A", "B", "C", "D", "E", "", "F");
        this.render(sending, c2, 11.0, 252.5, Fonts.font8bold, 11051);
        this.render(sending, c2, 15.0, 256.0, Fonts.font7, 11052, 11053);
        this.render(c2, 11.0, 256.0, Fonts.font7bold, "G");
        this.render(sending, c2, 11.0, 264.5, Fonts.font8bold, 11054, 11055);
        this.render(sending, c2, 15.0, 271.5, Fonts.font7, 11056, 11057, 11058, 11059);
        this.render(c2, 11.0, 271.5, Fonts.font7bold, "H", "I");
        this.render(sending, c2, 152.0, 11.0, Fonts.font8, 11000);
        this.render(sending, c2, 155.0, 51.0, Fonts.font6, 11033);
        this.render(sending, c2, 155.0, 55.5, Fonts.font6, 11034);
        this.render(sending, c2, 187.0, 50.0, Fonts.font9, 11035);
        this.render(sending, c2, 187.0, 54.5, Fonts.font9, 11035);
        this.render(sending, c2, 187.0, 59.0, Fonts.font9, 11035);
        this.render(sending, c2, 11.0, 286.5, Fonts.font8bold, 11060);
    }

    private String format(Sending sending, int textId, String arg) {
        return String.format(this.getText(sending, textId), arg);
    }

    protected void renderTotals(Sending sending, IDataContext dataContext, IRenderContext renderContext) {
        DecimalNode totalGrossMass = this.getItemList(sending).getTotalGrossMass(0, dataContext.to());
        renderContext.drawStringRightAligned(171.0, 205.0, Fonts.font9, Color.BLACK, totalGrossMass.toString());
        DecimalNode statisticalValueChf = this.getItemList(sending).getTotalStatisticalValueChf(0, dataContext.to());
        renderContext.drawStringRightAligned(196.0, 205.0, Fonts.font9, Color.BLACK, statisticalValueChf.toString());
    }

    protected void renderConsignee(Sending sending, IRenderContext renderContext) {
        int addressMode = sending.getForms().getBg().getConsigneeAddressMode().getIntValue();
        AddressRenderer renderer = addressMode == 0 ? sending.getGoodsDeclaration().getConsignee().getAddress() : sending.getGoodsDeclaration().getDelivery().getAddress();
        renderer.render(renderContext, 15.0, 42.0, Fonts.font9);
    }

    protected void renderConsignor(Sending sending, IRenderContext renderContext) {
        AddressRenderer renderer = sending.getGoodsDeclaration().getConsignor().getAddress();
        renderer.render(renderContext, 15.0, 15.0, Fonts.font9);
    }

    private void renderFreeTextField(Sending sending, IDataContext dataContext, IRenderContext rc) {
        if (!this.showFreeText(dataContext, 7)) {
            return;
        }
        String text = sending.getForms().getUz().getFreeText().getValue();
        rc.drawStringWrap(16.0, 161.0, 120.0, Fonts.font9, Color.BLACK, text);
    }

    @Override
    public Color getTextBackgroundColor() {
        return BG_COLOR;
    }
}

