/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.form.forms.cmr;

import ch.transsoft.edec.model.infra.AddressRenderer;
import ch.transsoft.edec.model.infra.node.DecimalNode;
import ch.transsoft.edec.model.infra.node.FileNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.goodsdeclaration.Address;
import ch.transsoft.edec.model.sending.itemlist.ItemList;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.form.AbstractFormPageDesc;
import ch.transsoft.edec.service.form.desc.Fonts;
import ch.transsoft.edec.service.form.render.IDataContext;
import ch.transsoft.edec.service.form.render.IRenderContext;
import ch.transsoft.edec.service.form.render.IUnitConverter;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import ch.transsoft.edec.ui.gui.control.StringArea;
import ch.transsoft.edec.ui.gui.sending.forms.PageContentPanel;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.util.Base64;
import ch.transsoft.edec.util.FileChooserUtil;
import ch.transsoft.edec.util.FileUtil;
import ch.transsoft.edec.util.disposable.Disposables;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public abstract class CmrLayoutBase
extends AbstractFormPageDesc {
    private static final int ROW_LIMIT_FOR_FREE_TEXT = 8;
    private static final int FREE_TEXT_X = 15;
    private static final int FREE_TEXT_Y = 166;
    private static final int FREE_TEXT_WIDTH = 116;
    private static final int FREE_TEXT_HEIGHT = 13;

    public CmrLayoutBase() {
        super(Sending.FormName.cmr);
    }

    @Override
    public String getPrintName() {
        return Services.getText(740);
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.getIcon("icon/forms/white.png");
    }

    @Override
    public double getLineHeight() {
        return 4.5;
    }

    @Override
    public int getLinesPerPage() {
        return 14;
    }

    @Override
    public void addControls(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2) {
        this.addStampChooseButton(sending, panel, c2);
        this.addFreeText(disposables, sending, panel, c2);
    }

    private void addStampChooseButton(Sending sending, PageContentPanel panel, IUnitConverter c2) {
        JButton button = this.addButton(panel, c2, Services.getText(741), 48, 260, 21.0, 4.66);
        button.addActionListener(e2 -> this.loadStampImage(sending));
    }

    private void addFreeText(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2) {
        StringArea freeText = this.addStringArea(disposables, sending.getForms().getCmr().getFreeTextInGoodsItemList(), panel, c2, 15, 166, 116, 13);
        this.addRowsListener(disposables, panel.getDataContext(), freeText, 8);
    }

    private void loadStampImage(Sending sending) {
        FileNode lastFolder = Services.get(IConfigService.class).getPreferences().getLastUsedFolders().getCmrStampImageFolder();
        File[] files = FileChooserUtil.chooseFiles(lastFolder.getValue(), Services.getText(742), "", Services.getText(306));
        if (files.length != 1) {
            return;
        }
        File imageFile = files[0];
        lastFolder.setValue(imageFile.getParentFile());
        Services.get(IConfigService.class).savePreferences();
        try {
            ImageIO.read(imageFile);
            String base64 = Base64.encodeBytes(FileUtil.getFileAsByteArray(imageFile));
            sending.getForms().getCmr().getStampImage().setValue(base64);
        }
        catch (Exception e2) {
            DialogUtil.showInfoDialog("Bild konnte nicht ge\u00f6ffnet werden", e2.getMessage());
        }
    }

    @Override
    public void render(Sending sending, ItemList goodsItems, IDataContext dataContext, IRenderContext renderContext) {
        this.render(sending, goodsItems, dataContext, renderContext, false);
    }

    public void render(Sending sending, ItemList goodsItems, IDataContext dataContext, IRenderContext renderContext, boolean english) {
        this.renderTotalGrossMass(goodsItems, dataContext, renderContext);
        this.renderConsignor(sending, renderContext);
        this.renderConsignee(sending, renderContext);
        this.renderDeliveryPlace(sending, renderContext, english);
        this.renderStamp(sending, renderContext);
        this.renderFreeTextField(sending, dataContext, renderContext);
    }

    private void renderFreeTextField(Sending sending, IDataContext dataContext, IRenderContext rc) {
        if (rc.isScreen()) {
            return;
        }
        if (!this.showFreeText(dataContext, 8)) {
            return;
        }
        String text = sending.getForms().getCmr().getFreeTextInGoodsItemList().getValue();
        rc.drawStringWrap(15.0, 166.0, 116.0, Fonts.font8, Color.BLACK, text);
    }

    private void renderStamp(Sending sending, IRenderContext renderContext) {
        StringNode imageString = sending.getForms().getCmr().getStampImage();
        if (!imageString.isInitialized()) {
            return;
        }
        try {
            byte[] imageBytes = Base64.decode(imageString.getValue());
            ByteArrayInputStream bais = new ByteArrayInputStream(imageBytes);
            BufferedImage image = ImageIO.read(bais);
            renderContext.renderIcon(15.0, 261.0, 54.0, 18.0, image);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    void renderDeliveryPlace(Sending sending, IRenderContext c2, boolean english) {
        Address address = sending.getDeliveryAddress();
        c2.drawString(34.0, 79.5, Fonts.font8, Color.BLACK, address.getZipAndCity());
        String country = english ? address.getCountry().getValue().getDescEn() : address.getCountry().getValue().getDesc();
        c2.drawString(34.0, 83.5, Fonts.font8, Color.BLACK, country);
    }

    private void renderTotalGrossMass(ItemList goodsItems, IDataContext dataContext, IRenderContext renderContext) {
        DecimalNode totalGrossMass = goodsItems.getTotalGrossMass(0, dataContext.to());
        renderContext.drawStringRightAligned(170.0, 217.5, Fonts.font8, Color.BLACK, totalGrossMass.toString());
    }

    private void renderConsignor(Sending sending, IRenderContext renderContext) {
        AddressRenderer renderer = sending.getGoodsDeclaration().getConsignor().getAddress();
        renderer.render(renderContext, 35.0, 16.0, Fonts.font8);
    }

    private void renderConsignee(Sending sending, IRenderContext renderContext) {
        AddressRenderer renderer = sending.getGoodsDeclaration().getConsignee().getAddress();
        renderer.render(renderContext, 35.0, 50.0, Fonts.font8);
    }
}

