/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.form.forms.list;

import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.itemlist.ItemList;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsItem;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.form.FormBase;
import ch.transsoft.edec.service.form.forms.list.GoodsItemComparator;
import ch.transsoft.edec.service.form.forms.list.ItemKey;
import ch.transsoft.edec.service.form.forms.list.ItemListFormFront;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class ItemListForm
extends FormBase {
    public ItemListForm() {
        super(Sending.FormName.itemListForm);
        this.add(new ItemListFormFront());
    }

    @Override
    public Sending.FormName getId() {
        return Sending.FormName.itemListForm;
    }

    @Override
    public String getName() {
        return Services.getText(970);
    }

    @Override
    public ItemList getGoodsItems(Sending sending) {
        HashMap<ItemKey, GoodsItem> map = new HashMap<ItemKey, GoodsItem>();
        for (GoodsItem current : sending.getItemList().getGoodsItems()) {
            ItemKey key = new ItemKey(current.getGoodsData().getCommodityCode().getValue(), current.getGoodsData().getOrigin().getValue().getKey(), current.getGoodsData().getCurrency().getValue());
            GoodsItem existing = (GoodsItem)map.get(key);
            if (existing != null) {
                existing.getGoodsData().getNetMass().cumulate(current.getGoodsData().getNetMass());
                existing.getGoodsData().getStatisticalValue().cumulate(current.getGoodsData().getStatisticalValue());
                existing.getGoodsData().getAdditionalUnit().cumulate(current.getGoodsData().getAdditionalUnit());
                continue;
            }
            map.put(key, (GoodsItem)current.getCopy((ModelNode)null));
        }
        ArrayList<GoodsItem> result = new ArrayList<GoodsItem>(map.values());
        Collections.sort(result, new GoodsItemComparator());
        for (int i2 = 1; i2 <= result.size(); ++i2) {
            ((GoodsItem)result.get(i2 - 1)).getGoodsData().getTraderItemID().setValue(Long.valueOf(i2));
        }
        return new ItemList(result);
    }
}

