/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.form.forms.uz;

import ch.transsoft.edec.model.infra.AddressRenderer;
import ch.transsoft.edec.model.infra.node.BooleanNode;
import ch.transsoft.edec.model.infra.node.DecimalNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.itemlist.ItemList;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.form.AbstractFormPageDesc;
import ch.transsoft.edec.service.form.desc.Fonts;
import ch.transsoft.edec.service.form.forms.uz.ChamberTexts;
import ch.transsoft.edec.service.form.render.IDataContext;
import ch.transsoft.edec.service.form.render.IRenderContext;
import ch.transsoft.edec.service.form.render.IUnitConverter;
import ch.transsoft.edec.service.masterdataezv.DomainValue;
import ch.transsoft.edec.service.text.ITextService;
import ch.transsoft.edec.ui.gui.control.StringArea;
import ch.transsoft.edec.ui.gui.sending.forms.PageContentPanel;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.ui.pm.model.SelectionPm;
import ch.transsoft.edec.ui.pm.model.StringPm;
import ch.transsoft.edec.util.disposable.Disposables;
import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JRadioButton;

public class UZlayout1
extends AbstractFormPageDesc {
    private static final int ROW_LIMIT_FOR_FREE_TEXT = 7;
    private static final int FREE_TEXT_X = 15;
    private static final int FREE_TEXT_Y = 170;
    private static final int FREE_TEXT_WIDTH = 120;
    private static final int FREE_TEXT_HEIGHT = 48;
    private static final Image uzIcon = IconLoader.getIcon("icon/forms/uz_icon.png").getImage();
    private static final Image uzIconLi = IconLoader.getIcon("icon/forms/uz_icon_li.png").getImage();

    public UZlayout1() {
        super(Sending.FormName.uz);
    }

    @Override
    public URL getDescUrl() {
        return this.getClass().getResource("layout1.xml");
    }

    @Override
    public String getGuiName() {
        return Services.getText(2200);
    }

    @Override
    public String getId() {
        return "uz_1";
    }

    @Override
    public double getLineHeight() {
        return 4.0;
    }

    @Override
    public int getLinesPerPage() {
        return 14;
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.getIcon("icon/forms/uz.png");
    }

    @Override
    public void addControls(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2) {
        this.addChooseConsigneeAddressMode(sending, panel, c2, disposables);
        this.addFreeText(disposables, sending, panel, c2);
        this.addChamberOfCommerceChooser(disposables, sending, panel, c2);
        this.addPrintInfo(panel, c2);
        this.addCheckboxForItemDescriptionLanguageSelection(panel, c2, sending, disposables);
    }

    private void addChooseConsigneeAddressMode(Sending sending, PageContentPanel panel, IUnitConverter c2, Disposables disposables) {
        ButtonGroup radioGroup = new ButtonGroup();
        JRadioButton mode1 = this.addRadioButton(panel, c2, radioGroup, 70.0, 70.0, Services.getText(788));
        JRadioButton mode2 = this.addRadioButton(panel, c2, radioGroup, 70.0, 75.0, Services.getText(789));
        this.connectRadio(disposables, null, sending.getForms().getUz().getConsigneeAddressMode(), mode1, mode2);
    }

    private void addCheckboxForItemDescriptionLanguageSelection(PageContentPanel panel, IUnitConverter c2, Sending sending, Disposables disposables) {
        BooleanNode node = sending.getForms().getUz().getDescriptionInEnglish();
        this.addCheckBox(disposables, panel, c2, Services.getText(889), node, 90.0, 134.0);
    }

    private void addPrintInfo(PageContentPanel panel, IUnitConverter c2) {
        this.addInfoIcon(panel, c2, 166, true, 105.0, 5.9, 16);
    }

    private void addChamberOfCommerceChooser(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2) {
        SelectionPm pm = new SelectionPm(sending.getForms().getUz().getChamgerOfCommerceChooser());
        disposables.add(pm);
        this.addSelectionField(panel, pm, c2, 10.0, 4.5, 20.0, 5.0);
    }

    private void addFreeText(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2) {
        StringPm freeTextPm = new StringPm(sending.getForms().getUz().getFreeText());
        disposables.add(freeTextPm);
        StringArea freeText = this.addStringArea(panel, freeTextPm, 12);
        freeText.getTextArea().setFont(c2.getFont(Fonts.font9));
        freeText.setBounds(new Rectangle(c2.px(15.0), c2.py(170.0), c2.px(120.0), c2.py(48.0)));
        this.addRowsListener(disposables, panel.getDataContext(), freeText, 7);
    }

    @Override
    public void render(Sending sending, ItemList goodsItems, IDataContext dataContext, IRenderContext renderContext) {
        this.renderIcon(sending, renderContext);
        this.renderTitles(sending, renderContext);
        this.renderFreeTextField(sending, dataContext, renderContext);
        this.renderConsignor(sending, renderContext);
        this.renderConsignee(sending, renderContext);
        this.renderTotals(sending, dataContext, renderContext);
        this.renderFooter(sending, renderContext);
    }

    private void renderFooter(Sending sending, IRenderContext c2) {
        DomainValue value = sending.getForms().getUz().getChamgerOfCommerceChooser().getValue();
        if (!value.isInitialized()) {
            return;
        }
        String[] lines = new String[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            lines[i2] = ChamberTexts.getText(value, i2);
        }
        double textBlockSize = c2.getTextBlockSize(Fonts.font8bold, lines);
        c2.drawString(191.0 - textBlockSize, 253.0, 2, Fonts.font8bold, Color.BLACK, lines);
        c2.drawString(11.0, 260.0, Fonts.font8, Color.BLACK, ChamberTexts.getText(value, 4));
    }

    private void renderTitles(Sending sending, IRenderContext renderContext) {
        renderContext.drawString(152.0, 12.5, Fonts.font8, Color.BLACK, this.getText(sending, 10038));
        renderContext.drawString(152.0, 17.0, Fonts.font8, Color.BLACK, this.getText(sending, 10039));
        this.renderSmallBlock(sending, renderContext, 10000, 11, 13, "Exporter");
        this.renderSmallBlock(sending, renderContext, 10003, 11, 41, "Consignee");
        this.renderSmallBlock(sending, renderContext, 10006, 11, 89, "Particulars of transport (optional declaration)");
        this.renderSmallBlock(sending, renderContext, 10009, 11, 124, "Marks, numbers, number and kind of packages; description of the goods");
        this.renderBlock(sending, renderContext, 10012, 103, 27, 4.0, Fonts.font10bold, Fonts.font10bold, "CERTIFICATE OF ORIGIN");
        this.renderBlock(sending, renderContext, 10018, 103, 68, 3.0, Fonts.font8bold, Fonts.font8, "Country of origin");
        this.renderSmallBlock(sending, renderContext, 10021, 103, 89, "Observations");
        this.renderSmallBlock(sending, renderContext, 10024, 151, 124, "Net weight", "kg, l, m\u00b3", "etc./ecc");
        this.renderSmallBlock(sending, renderContext, 10027, 151, 202, "Gross weight");
        this.renderBlock(sending, renderContext, 10030, 11, 225, 3.0, Fonts.font8bold, Fonts.font8, "The undersigned Chamber of commerce certifies the origin of the above mentioned goods");
    }

    private void renderIcon(Sending sending, IRenderContext renderContext) {
        if (sending.getForms().getUz().getChamgerOfCommerceChooser().getValue() == ChamberTexts.FL) {
            renderContext.renderIcon(168.0, 38.0, 14.0, 19.0, uzIconLi);
            this.renderBlock(sending, renderContext, 10034, 103, 50, 3.0, Fonts.font8bold, Fonts.font8bold, "PRINCIPALITY OF LIECHTENSTEIN");
        } else {
            renderContext.renderIcon(173.0, 49.0, 14.0, 14.0, uzIcon);
            this.renderBlock(sending, renderContext, 10015, 103, 50, 3.0, Fonts.font8bold, Fonts.font8bold, "SWISS CONFEDERATION");
        }
    }

    private void renderTotals(Sending sending, IDataContext dataContext, IRenderContext renderContext) {
        DecimalNode totalGrossMass = this.getItemList(sending).getTotalGrossMass(0, dataContext.to());
        renderContext.drawStringRightAligned(173.0, 214.0, Fonts.font9, Color.BLACK, totalGrossMass.toString());
    }

    private void renderConsignee(Sending sending, IRenderContext renderContext) {
        int addressMode = sending.getForms().getUz().getConsigneeAddressMode().getIntValue();
        AddressRenderer renderer = addressMode == 0 ? sending.getGoodsDeclaration().getConsignee().getAddress() : sending.getGoodsDeclaration().getDelivery().getAddress();
        renderer.render(renderContext, 25.0, 41.0, Fonts.font9);
    }

    private void renderConsignor(Sending sending, IRenderContext renderContext) {
        AddressRenderer renderer = sending.getGoodsDeclaration().getConsignor().getAddress();
        renderer.render(renderContext, 25.0, 13.0, Fonts.font9);
    }

    private void renderFreeTextField(Sending sending, IDataContext dataContext, IRenderContext rc) {
        if (rc.isScreen()) {
            return;
        }
        if (!this.showFreeText(dataContext, 7)) {
            return;
        }
        String text = sending.getForms().getUz().getFreeText().getValue();
        rc.drawStringWrap(15.0, 170.0, 120.0, Fonts.font9, Color.BLACK, text);
    }

    private void renderSmallBlock(Sending sending, IRenderContext c2, int l1, int x, int y, String ... lines) {
        this.renderBlock(sending, c2, l1, x, y, 2.5, Fonts.font6bold, Fonts.font6, lines);
    }

    protected void renderBlock(Sending sending, IRenderContext c2, int l1, int x, int y, double lineHeight, Fonts font1, Fonts font2, String ... lines) {
        ArrayList<String> lineList = new ArrayList<String>();
        lineList.add(this.getText(sending, l1));
        lineList.add(this.getText(sending, l1 + 1));
        lineList.add(this.getText(sending, l1 + 2));
        lineList.addAll(Arrays.asList(lines));
        c2.drawString((double)x, (double)y, -1, font1, font2, Color.BLACK, lineList.toArray(new String[lineList.size()]));
    }

    private String getText(Sending sending, int id) {
        return Services.get(ITextService.class).getText(this.getLanguage(sending), id);
    }

    private ITextService.Language getLanguage(Sending sending) {
        DomainValue chamber = sending.getForms().getUz().getChamgerOfCommerceChooser().getValue();
        if (!chamber.isInitialized()) {
            return Services.get(ITextService.class).getCurrentLanguage();
        }
        return ChamberTexts.getLanguage(chamber);
    }
}

