/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.form.render;

import ch.transsoft.edec.model.infra.event.IChangeInfo;
import ch.transsoft.edec.model.infra.event.IChangeListener;
import ch.transsoft.edec.model.infra.node.INode;
import ch.transsoft.edec.model.sending.itemlist.ItemList;
import ch.transsoft.edec.service.form.IFormPageDesc;
import ch.transsoft.edec.service.form.desc.GoodsItemDesc;
import ch.transsoft.edec.service.form.render.IDataContext;
import ch.transsoft.edec.service.form.render.IUnitConverter;
import ch.transsoft.edec.service.form.render.TextRenderer;
import ch.transsoft.edec.ui.gui.sending.forms.UnitConverterFactory;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.disposable.IDisposable;
import ch.transsoft.edec.util.disposable.ListenerList;
import java.util.ArrayList;
import java.util.List;

public class DataContext
implements IDataContext {
    private final List<PageDesc> pages = new ArrayList<PageDesc>();
    private int currentPage;
    private final int maxLinesPerPage;
    private int[] linesPerPosition;
    private ItemList goodsItems;
    private final IFormPageDesc formPageDesc;
    private final ListenerList<IChangeListener> listeners = new ListenerList();
    private static final IUnitConverter printUnitConverter = UnitConverterFactory.createPrintConverter();

    public DataContext(ItemList goodsItems, IFormPageDesc formPageDesc) {
        this.goodsItems = goodsItems;
        this.formPageDesc = formPageDesc;
        this.maxLinesPerPage = formPageDesc.getLinesPerPage();
        this.linesPerPosition = this.computeLinesPerPosition();
        this.distributePositionsAcrossPages();
        this.setCurrentPage(1);
    }

    private void setCurrentPage(int part) {
        Check.assertTrue(part > 0, "invalid state", part);
        Check.assertTrue(part <= this.getPageCount(), "invalid state", part);
        this.currentPage = part;
    }

    private void distributePositionsAcrossPages() {
        this.pages.clear();
        if (this.maxLinesPerPage == 0) {
            this.pages.add(new PageDesc(0));
            return;
        }
        PageDesc page = new PageDesc(0);
        this.pages.add(page);
        for (int i2 = 0; i2 < this.goodsItems.size(); ++i2) {
            int lines = this.linesPerPosition[i2];
            if (!page.hasSpace(lines)) {
                page = new PageDesc(i2);
                this.pages.add(page);
            }
            page.addPosition(i2, lines);
        }
    }

    private int[] computeLinesPerPosition() {
        int[] result = new int[this.goodsItems.size()];
        for (int pos = 0; pos < this.goodsItems.size(); ++pos) {
            result[pos] = this.computeLinesForPosition(pos);
        }
        return result;
    }

    private int computeLinesForPosition(int pos) {
        int result = 1;
        for (GoodsItemDesc goodsItemDesc : this.formPageDesc.getGoodsItems()) {
            result = Math.max(result, this.computeLinesForItem(goodsItemDesc, pos));
        }
        return result;
    }

    private int computeLinesForItem(GoodsItemDesc goodsItemDesc, int pos) {
        String text = goodsItemDesc.getTextValue(this.goodsItems, pos, goodsItemDesc.getDescOnly().getValue(), goodsItemDesc.getKeyOnly().getValue());
        int width = printUnitConverter.px(goodsItemDesc.getWidth());
        TextRenderer textRenderer = new TextRenderer(printUnitConverter, text, goodsItemDesc, 0, 0, width, goodsItemDesc.getAlignRight().getValue());
        return textRenderer.getNumberOfLines();
    }

    @Override
    public int from() {
        return this.from(this.currentPage);
    }

    public int from(int page) {
        return this.pages.get(page - 1).getStart();
    }

    @Override
    public int to() {
        return this.to(this.currentPage);
    }

    public int to(int page) {
        if (this.goodsItems.isEmpty()) {
            return 0;
        }
        return this.pages.get(page - 1).getEnd() + 1;
    }

    @Override
    public int getPageCount() {
        return this.pages.size();
    }

    @Override
    public int getCurrentPage() {
        return this.currentPage;
    }

    public void decrementCurrentPart() {
        this.setCurrentPage(this.currentPage - 1);
    }

    public void incrementCurrentPart() {
        this.setCurrentPage(this.currentPage + 1);
    }

    public void recompute(ItemList itemList, INode<?> source, IChangeInfo info) {
        this.goodsItems = itemList;
        this.recompute(source, info);
    }

    public void recompute(INode<?> source, IChangeInfo info) {
        this.linesPerPosition = this.computeLinesPerPosition();
        this.distributePositionsAcrossPages();
        this.setCurrentPage(Math.min(this.currentPage, this.getPageCount()));
        this.notifyChangeListeners(source, info);
    }

    @Override
    public boolean isLastPart() {
        return this.currentPage == this.getPageCount();
    }

    @Override
    public boolean isFirstPart() {
        return this.currentPage == 1;
    }

    @Override
    public int getLineCount() {
        return this.pages.get(this.currentPage - 1).getLines();
    }

    @Override
    public int getFirstPageLineCount() {
        return this.pages.get(0).getLines();
    }

    @Override
    public int getLinesForPosition(int pos) {
        return this.linesPerPosition[pos];
    }

    public IDisposable addChangeListener(IChangeListener listener) {
        return this.listeners.add(listener);
    }

    private void notifyChangeListeners(INode<?> source, IChangeInfo info) {
        for (IChangeListener listener : this.listeners) {
            listener.changed(source, info);
        }
    }

    private class PageDesc {
        private final int start;
        private int end;
        private int lines = 0;
        private final boolean firstPage;

        public PageDesc(int start) {
            this.start = start;
            this.end = start;
            this.firstPage = start == 0;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public int getLines() {
            if (DataContext.this.formPageDesc.carryOverIsLineItem()) {
                return this.lines + (this.firstPage ? 0 : 1);
            }
            return this.lines;
        }

        public boolean hasSpace(int additionalLines) {
            return this.getLines() + additionalLines <= DataContext.this.maxLinesPerPage;
        }

        public void addPosition(int index, int lines) {
            this.lines += lines;
            this.end = index;
        }
    }
}

