/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.form.render;

import ch.transsoft.edec.service.form.desc.Fonts;
import ch.transsoft.edec.service.form.render.IRenderContext;
import ch.transsoft.edec.service.form.render.IUnitConverter;
import ch.transsoft.edec.util.TextUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.List;

public class RenderContext
implements IRenderContext {
    private final IUnitConverter c;
    private final Graphics2D g;
    private final IRenderContext.Mode mode;
    private final int copyNumber;

    public RenderContext(IUnitConverter unitConverter, Graphics2D g2, IRenderContext.Mode mode) {
        this(unitConverter, g2, mode, 1);
    }

    public RenderContext(IUnitConverter unitConverter, Graphics2D g2, IRenderContext.Mode mode, int copyNumber) {
        this.c = unitConverter;
        this.g = g2;
        this.mode = mode;
        this.copyNumber = copyNumber;
    }

    @Override
    public void drawLine(double x1, double y1, double x2, double y2, double size, Color color) {
        this.drawLine(this.c.px(x1), this.c.py(y1), this.c.px(x2), this.c.py(y2), size, color);
    }

    private void drawLine(int x1, int y1, int x2, int y2, double size, Color color) {
        this.g.setStroke(new BasicStroke((float)size));
        this.g.setColor(color);
        this.g.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawStringRightAligned(double x, double y, Fonts font, Color color, String text) {
        this.g.setColor(color);
        this.g.setFont(this.c.getFont(font));
        int lineHeight = this.g.getFontMetrics().getHeight();
        int yPos = lineHeight + this.c.py(y);
        int xPos = this.c.px(x) - this.g.getFontMetrics().stringWidth(text);
        this.g.drawString(text, xPos, yPos);
    }

    @Override
    public void drawStringCut(double x, double y, double maxWidth, Fonts font, Color color, String line) {
        this.g.setColor(color);
        this.g.setFont(this.c.getFont(font));
        int lineHeight = this.g.getFontMetrics().getHeight();
        line = TextUtil.cut(line, this.g.getFontMetrics(), this.c.px(maxWidth));
        int currentY = lineHeight + this.c.py(y);
        this.g.drawString(line, this.c.px(x), currentY);
    }

    @Override
    public void drawString(double x, double y, Fonts f1, Fonts f2, Color color, String ... lines) {
        this.drawString(x, y, 0, f1, f2, color, lines);
    }

    @Override
    public void drawString(double x, double y, int lineDelta, Fonts f1, Fonts f2, Color color, String ... lines) {
        this.g.setColor(color);
        this.g.setFont(this.c.getFont(f1));
        int lineHeight = this.getLineHeight(lineDelta);
        int currentY = lineHeight + this.c.py(y);
        this.g.drawString(lines[0], this.c.px(x), currentY);
        this.g.setFont(this.c.getFont(f2));
        currentY += lineHeight;
        for (int i2 = 1; i2 < lines.length; ++i2) {
            this.g.drawString(lines[i2], this.c.px(x), currentY);
            currentY += lineHeight;
        }
    }

    private int getLineHeight(int lineDelta) {
        return this.g.getFontMetrics().getHeight() + lineDelta;
    }

    @Override
    public void drawStringCentered(double x, double y, double width, Fonts font, Color color, String ... lines) {
        this.drawStringCentered(x, y, width, 0, font, color, lines);
    }

    @Override
    public void drawStringCentered(double x, double y, double width, int lineDelta, Fonts font, Color color, String ... lines) {
        this.g.setColor(color);
        this.g.setFont(this.c.getFont(font));
        int lineHeight = this.getLineHeight(lineDelta);
        int currentY = lineHeight + this.c.py(y);
        for (String line : lines) {
            this.drawCentered(x, y, width, line);
            currentY += lineHeight;
        }
    }

    private void drawCentered(double x, double y, double width, String line) {
        int xPos = this.c.px(x) + (this.c.px(width) - this.g.getFontMetrics().stringWidth(line)) / 2;
        this.g.drawString(line, xPos, this.c.py(y));
    }

    @Override
    public void drawString(double x, double y, Fonts font, Color color, String ... lines) {
        this.drawString(x, y, 0, this.c.getFont(font), color, lines);
    }

    @Override
    public void drawString(double x, double y, int lineDelta, Fonts font, Color color, String ... lines) {
        this.drawString(x, y, lineDelta, this.c.getFont(font), color, lines);
    }

    @Override
    public void drawString(double x, double y, int lineDelta, Font font, Color color, String ... lines) {
        this.g.setColor(color);
        this.g.setFont(font);
        int lineHeight = this.getLineHeight(lineDelta);
        int currentY = lineHeight + this.c.py(y);
        for (String line : lines) {
            this.g.drawString(line, this.c.px(x), currentY);
            currentY += lineHeight;
        }
    }

    @Override
    public void renderCheckBox(String str, Fonts font, boolean checked, double x, double y) {
        int w = 8;
        int i2 = 2;
        this.g.setColor(Color.BLACK);
        Font systemFont = this.c.getFont(font);
        this.g.setFont(systemFont);
        int lineHeight = this.g.getFontMetrics(systemFont).getHeight();
        this.g.drawString(str, this.c.px(x + 4.0), this.c.py(y) + lineHeight - 1);
        int px = this.c.px(x);
        int py = this.c.py(y) + lineHeight - 8;
        this.drawLine(px, py, px + 8, py, 0.5, Color.BLACK);
        this.drawLine(px + 8, py, px + 8, py + 8, 0.5, Color.BLACK);
        this.drawLine(px + 8, py + 8, px, py + 8, 0.5, Color.BLACK);
        this.drawLine(px, py, px, py + 8, 0.5, Color.BLACK);
        if (!checked) {
            return;
        }
        this.drawLine(px + 2, py + 2, px + 8 - 2, py + 8 - 2, 1.0, Color.BLACK);
        this.drawLine(px + 8 - 2, py + 2, px + 2, py + 8 - 2, 1.0, Color.BLACK);
    }

    @Override
    public void drawStringWrap(double x, double y, double width, Fonts font, Color color, String longText) {
        this.g.setFont(this.c.getFont(font));
        List<String> lines = TextUtil.splitAtWhitespace(this.g.getFontMetrics(), longText, this.c.px(width));
        this.drawString(x, y, font, color, lines.toArray(new String[lines.size()]));
    }

    @Override
    public void renderIcon(double x, double y, double width, double height, Image image) {
        this.g.drawImage(image, this.c.px(x), this.c.py(y), this.c.px(width), this.c.py(height), null);
    }

    @Override
    public void drawString(double x, double y, Fonts f1, Fonts f2, String s1, String s2) {
        this.g.setColor(Color.BLACK);
        this.g.setFont(this.c.getFont(f1));
        int yPos = this.g.getFontMetrics().getHeight() + this.c.py(y);
        int width = this.g.getFontMetrics().stringWidth(s1);
        this.g.drawString(s1, this.c.px(x), yPos);
        this.g.setFont(this.c.getFont(f2));
        this.g.drawString(s2, this.c.px(x) + width + 3, yPos);
    }

    @Override
    public double getTextBlockSize(Fonts font, String ... lines) {
        Font f2 = this.c.getFont(font);
        FontMetrics metric = this.g.getFontMetrics(f2);
        int px = 0;
        for (String line : lines) {
            px = Math.max(px, metric.stringWidth(line));
        }
        return this.c.mmx(px);
    }

    @Override
    public boolean isEmailAttachment() {
        return this.mode == IRenderContext.Mode.mail;
    }

    @Override
    public boolean isScreen() {
        return this.mode == IRenderContext.Mode.screen;
    }

    @Override
    public int getCopyNumber() {
        return this.copyNumber;
    }
}

