/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.form.render;

import ch.transsoft.edec.model.infra.node.INode;
import ch.transsoft.edec.model.infra.node.IPrimitive;
import ch.transsoft.edec.model.infra.node.NodeBase;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.itemlist.ItemList;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.form.IFormPageDesc;
import ch.transsoft.edec.service.form.desc.GoodsItemDesc;
import ch.transsoft.edec.service.form.desc.ITextDesc;
import ch.transsoft.edec.service.form.desc.LabelDesc;
import ch.transsoft.edec.service.form.desc.LineDesc;
import ch.transsoft.edec.service.form.desc.NodeDesc;
import ch.transsoft.edec.service.form.render.AlignRightSimpleTextRenderer;
import ch.transsoft.edec.service.form.render.IDataContext;
import ch.transsoft.edec.service.form.render.IRenderer;
import ch.transsoft.edec.service.form.render.IUnitConverter;
import ch.transsoft.edec.service.form.render.LineRenderer;
import ch.transsoft.edec.service.form.render.SimpleTextRenderer;
import ch.transsoft.edec.service.form.render.TextRenderer;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;

public abstract class RendererBase {
    private final List<IRenderer> renderers = new ArrayList<IRenderer>();
    private final IFormPageDesc formPageDesc;
    private final IDataContext dataContext;
    private final Graphics2D g;
    private final IUnitConverter uc;
    private final Sending sending;
    private final ItemList goodsItems;

    public RendererBase(Sending sending, ItemList goodsItems, IFormPageDesc formPageDesc, IDataContext dataContext, IUnitConverter unitConverter, Graphics2D g2) {
        this.sending = sending;
        this.goodsItems = goodsItems;
        this.dataContext = dataContext;
        this.uc = unitConverter;
        this.g = g2;
        this.formPageDesc = formPageDesc;
        this.addLabels();
        this.addNodes();
        this.addGoodsItems();
        this.addLines();
    }

    private void addGoodsItems() {
        if (this.formPageDesc.getGoodsItems().isEmpty()) {
            return;
        }
        int line = 0;
        if (!this.dataContext.isFirstPart()) {
            this.writeCarryover();
            line = 1;
        }
        for (int pos = this.dataContext.from(); pos < this.dataContext.to(); ++pos) {
            line += this.writeLine(pos, line);
        }
    }

    private int writeLine(int pos, int line) {
        int maxNumberOfLines = 1;
        for (GoodsItemDesc goodsItem : this.formPageDesc.getGoodsItems()) {
            int numberOfWrittenLines = this.writeItem(goodsItem, pos, line);
            maxNumberOfLines = Math.max(maxNumberOfLines, numberOfWrittenLines);
        }
        return maxNumberOfLines;
    }

    private int writeItem(GoodsItemDesc goodsItem, int pos, int line) {
        String text = goodsItem.getTextValue(this.goodsItems, pos, goodsItem.getDescOnly().getValue(), goodsItem.getKeyOnly().getValue());
        int y = this.uc.py(goodsItem.getY().getValue() + (double)line * this.formPageDesc.getLineHeight());
        TextRenderer renderer = this.createRenderer(goodsItem, text, y, this.uc.py(this.formPageDesc.getLineHeight()), goodsItem.getAlignRight().getValue());
        return renderer.getNumberOfLines();
    }

    private void writeCarryover() {
        double x = Double.MAX_VALUE;
        for (GoodsItemDesc goodsItem : this.formPageDesc.getGoodsItems()) {
            if (goodsItem.getCarryover().getValue().booleanValue()) {
                this.computeAndWriteCarryOver(goodsItem);
            }
            x = Math.min(x, goodsItem.getX().getValue());
        }
        this.writeCarryoverLabel(x);
    }

    private void computeAndWriteCarryOver(GoodsItemDesc goodsItem) {
        String sum = goodsItem.getSum(this.goodsItems, 0, this.dataContext.from());
        Font font = this.uc.getFont(this.formPageDesc.getGoodsItems().get(0).getFontValue());
        this.renderers.add(new AlignRightSimpleTextRenderer(sum, this.uc.px(goodsItem.getX()), this.uc.py(goodsItem.getY()), this.uc.px(goodsItem.getWidth()), font));
    }

    private void writeCarryoverLabel(double x) {
        double y = this.formPageDesc.getGoodsItems().get(0).getY().getValue();
        Font font = this.uc.getFont(this.formPageDesc.getGoodsItems().get(0).getFontValue());
        Object text = this.isFormEnglish() ? "Carryover" : Services.getText(2103);
        text = (String)text + " " + this.dataContext.getCurrentPage() + "/" + this.dataContext.getPageCount();
        this.renderers.add(new SimpleTextRenderer((String)text, this.uc.px(x), this.uc.py(y), font));
    }

    private boolean isFormEnglish() {
        return this.sending.getForms().findForm(this.formPageDesc.getFormName()).isFormEnglish();
    }

    protected abstract boolean includeNode(NodeDesc var1);

    protected abstract boolean includeLabel(LabelDesc var1);

    protected abstract boolean includeLine(LineDesc var1);

    private void addNodes() {
        for (NodeDesc node : this.formPageDesc.getNodes()) {
            if (!this.includeNode(node)) continue;
            if (node.getFindAll().getValue().booleanValue()) {
                this.createRenderer(node);
                continue;
            }
            this.createRenderer(node, node.getTextValue(this.sending), node.getAlignRight().getValue());
        }
    }

    private void createRenderer(NodeDesc node) {
        int y = this.uc.py(node.getY());
        int x = this.uc.px(node.getX());
        List<String> texts = node.getTextValues(this.sending);
        this.renderers.add(new TextRenderer(this.uc, texts, node, x, y, false));
    }

    private void createRenderer(ITextDesc node, String text, boolean alignRight) {
        int y = this.uc.py(node.getY());
        this.createRenderer(node, text, y, alignRight);
    }

    private void createRenderer(ITextDesc node, String text, int y, boolean alignRight) {
        int x = this.uc.px(node.getX());
        int width = this.uc.px(node.getWidth());
        this.renderers.add(new TextRenderer(this.uc, text, node, this.g, x, y, width, alignRight));
    }

    private TextRenderer createRenderer(ITextDesc node, String text, int y, int lineHeight, boolean alignRight) {
        int x = this.uc.px(node.getX());
        int width = this.uc.px(node.getWidth());
        TextRenderer renderer = new TextRenderer(this.uc, text, node, this.g, x, y, width, lineHeight, alignRight);
        this.renderers.add(renderer);
        return renderer;
    }

    private void addLines() {
        for (LineDesc line : this.formPageDesc.getLines()) {
            if (!this.includeLine(line)) continue;
            this.renderers.add(new LineRenderer(this.uc, line, this.g));
        }
    }

    private void addLabels() {
        for (LabelDesc label : this.formPageDesc.getLabels()) {
            if (!this.includeLabel(label)) continue;
            this.createRenderer(label, label.getTextValue(this.sending), label.getAlignRight().getValue());
        }
    }

    public void render(Graphics2D g2) {
        for (IRenderer renderer : this.renderers) {
            renderer.render(g2);
        }
    }

    protected void addRenderer(IRenderer renderer) {
        this.renderers.add(renderer);
    }

    protected Sending getSending() {
        return this.sending;
    }

    protected boolean includeDependentLabel(LabelDesc node) {
        if (!node.getDepends().isInitialized()) {
            return true;
        }
        INode<?> p = this.getSending().find(node.getDepends().getValue());
        if (p instanceof IPrimitive) {
            return ((IPrimitive)p).isInitialized();
        }
        if (p instanceof NodeBase) {
            return ((NodeBase)p).isEnabled();
        }
        return true;
    }
}

