/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.form.render;

import ch.transsoft.edec.service.form.desc.ITextDesc;
import ch.transsoft.edec.service.form.render.IRenderer;
import ch.transsoft.edec.service.form.render.IUnitConverter;
import ch.transsoft.edec.ui.gui.sending.forms.UnitConverterFactory;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.TextUtil;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class TextRenderer
implements IRenderer {
    private final int x;
    private final int y;
    private final int width;
    private final Font font;
    private List<String> lines;
    private final boolean alignRight;
    private final int lineExtensionPx;
    private int lineHeightWrapped;
    private boolean customLineHeight = false;

    public TextRenderer(IUnitConverter c2, String text, ITextDesc desc, Graphics g2, int x, int y, int width, boolean alignRight) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.alignRight = alignRight;
        this.font = c2.getFont(desc.getFontValue());
        this.lineExtensionPx = desc.getLineExtensionPx();
        FontMetrics metrics = g2.getFontMetrics(this.font);
        this.splitText(text, desc, metrics);
    }

    public TextRenderer(IUnitConverter c2, String text, ITextDesc desc, Graphics g2, int x, int y, int width, int lineHeightWrapped, boolean alignRight) {
        this(c2, text, desc, g2, x, y, width, alignRight);
        this.lineHeightWrapped = lineHeightWrapped;
        this.customLineHeight = true;
    }

    public TextRenderer(IUnitConverter c2, String text, ITextDesc desc, int x, int y, int width, boolean alignRight) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.alignRight = alignRight;
        this.font = c2.getFont(desc.getFontValue());
        this.lineExtensionPx = desc.getLineExtensionPx();
        BufferedImage bi = new BufferedImage(1, 1, 3);
        Graphics2D g2 = (Graphics2D)bi.getGraphics();
        UnitConverterFactory.setRenderingHints(g2);
        FontMetrics metrics = g2.getFontMetrics(this.font);
        g2.dispose();
        this.splitText(text, desc, metrics);
    }

    public TextRenderer(IUnitConverter c2, List<String> texts, ITextDesc desc, int x, int y, boolean alignRight) {
        this.width = -1;
        this.x = x;
        this.y = y;
        this.alignRight = alignRight;
        this.font = c2.getFont(desc.getFontValue());
        this.lineExtensionPx = desc.getLineExtensionPx();
        this.lines = texts;
    }

    private void splitText(String text, ITextDesc desc, FontMetrics metrics) {
        switch (desc.getTextStrategyValue()) {
            case none: {
                this.lines = new ArrayList<String>();
                this.lines.add(text);
                break;
            }
            case cut: {
                this.lines = new ArrayList<String>();
                this.lines.add(TextUtil.cut(text, metrics, this.width));
                break;
            }
            case wrap: {
                this.lines = this.wrap(text, desc, metrics);
                break;
            }
            default: {
                Check.fail(new Object[]{"Unknown textstrategy:", desc.getTextStrategyValue()});
            }
        }
    }

    private List<String> wrap(String text, ITextDesc desc, FontMetrics metrics) {
        if (desc.splitAtWhitespace()) {
            return TextUtil.splitAtWhitespace(metrics, text, this.width);
        }
        return TextUtil.split(metrics, text, this.width);
    }

    @Override
    public void render(Graphics2D g2) {
        int lineHeight;
        g2.setFont(this.font);
        FontMetrics metrics = g2.getFontMetrics();
        int offset = lineHeight = metrics.getHeight();
        for (String line : this.lines) {
            int xPos = this.alignRight ? this.x + this.width - metrics.stringWidth(line) : this.x;
            g2.drawString(line, xPos, this.y + offset);
            offset += this.customLineHeight ? this.lineHeightWrapped : lineHeight + this.lineExtensionPx;
        }
    }

    public int getNumberOfLines() {
        return this.lines.size();
    }
}

