/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.gui;

import ch.transsoft.edec.model.config.conf.license.LicenseInfo;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.action.ExportActionService;
import ch.transsoft.edec.service.action.IActionService;
import ch.transsoft.edec.service.action.ImportActionService;
import ch.transsoft.edec.service.app.IAppService;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.service.gui.IModuleListener;
import ch.transsoft.edec.service.text.ITextService;
import ch.transsoft.edec.ui.gui.EvvImportPanel;
import ch.transsoft.edec.ui.gui.ExportPanel;
import ch.transsoft.edec.ui.gui.bar.ExportMenu;
import ch.transsoft.edec.ui.gui.bar.ImportMenu;
import ch.transsoft.edec.ui.gui.bar.StateDisplay;
import ch.transsoft.edec.ui.gui.bar.StateDisplayFacade;
import ch.transsoft.edec.ui.gui.control.IInputField;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.ui.pm.EvvImportPm;
import ch.transsoft.edec.ui.pm.ExportPm;
import ch.transsoft.edec.ui.pm.IModulePm;
import ch.transsoft.edec.ui.pm.imp.ImportModel;
import ch.transsoft.edec.ui.pm.templates.TemplateModel;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.ReflectionUtil;
import ch.transsoft.edec.util.SystemUtil;
import ch.transsoft.edec.util.disposable.IDisposable;
import ch.transsoft.edec.util.disposable.ListenerList;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.Timer;

public class GuiService
implements IGuiService {
    private IInputField focusInputField;
    private Timer timer;
    private boolean hourGlassCursor = false;
    private JFrame frame;
    private StateDisplay statusDisplay;
    private StateDisplayFacade statusDisplayFacade;
    private IModulePm modulePm;
    private ExportPanel exportPanel;
    private TemplateModel templateModel;
    private ImportModel importModel;
    private final IActionService exportActionService = new ExportActionService();
    private final IActionService importActionService = new ImportActionService();
    private EvvImportPanel importPanel;
    private final ListenerList<IModuleListener> moduleListeners = new ListenerList();

    public GuiService() {
        this.startCommitTimer();
        this.addFocusListener();
        this.addLanguageListener();
    }

    public static void addIcons(Window frame) {
        ArrayList<Image> imageList = new ArrayList<Image>();
        imageList.add(IconLoader.getIcon("icon/logo/icon-32x32.png").getImage());
        imageList.add(IconLoader.getIcon("icon/logo/icon-24x24.png").getImage());
        imageList.add(IconLoader.getIcon("icon/logo/icon-16x16.png").getImage());
        frame.setIconImages(imageList);
    }

    private void addLanguageListener() {
        Services.get(ITextService.class).add(() -> Services.get(IActionService.class).languageChanged());
    }

    @Override
    public JFrame createMainFrame() {
        Check.checkEDT();
        String windowTitle = "ExpoVit e-dec " + Services.get(IConfigService.class).getVersionString() + "  " + SystemUtil.getDeployString();
        this.frame = new JFrame(windowTitle);
        GuiService.addIcons(this.frame);
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                Services.get(IAppService.class).handleExitRequest();
            }

            @Override
            public void windowClosed(WindowEvent e2) {
                try {
                    Services.get(IBackendService.class).shutdown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.createUi();
        return this.frame;
    }

    @Override
    public void createUi() {
        if (this.modulePm != null) {
            this.frame.getContentPane().removeAll();
            ReflectionUtil.recursiveDispose(this.modulePm);
            this.modulePm = null;
            this.templateModel = null;
            this.exportPanel = null;
            this.importModel = null;
            this.focusInputField = null;
        }
        if (Services.get(IConfigService.class).isModuleExport()) {
            Services.setService(IActionService.class, this.exportActionService);
            this.exportActionService.initActionsWithListener();
            this.modulePm = new ExportPm();
            this.statusDisplay = new StateDisplay(this.modulePm);
            this.statusDisplayFacade = new StateDisplayFacade(this.statusDisplay);
            this.templateModel = new TemplateModel();
            this.importModel = new ImportModel();
            this.exportPanel = new ExportPanel((ExportPm)this.modulePm);
            this.frame.setContentPane(this.exportPanel);
            LicenseInfo licenseInfo = Services.get(IConfigService.class).getLicenseInfo();
            if (licenseInfo.hasLicenseForModuleEvvExport() && !licenseInfo.hasLicenseForModuleEdecExport()) {
                this.selectExportTab(ExportTab.sendingList);
            } else {
                this.selectExportTab(ExportTab.header);
            }
            this.frame.setJMenuBar(new ExportMenu().createMenuBar(this.modulePm));
        } else {
            Services.setService(IActionService.class, this.importActionService);
            this.importActionService.initActionsWithListener();
            this.modulePm = new EvvImportPm();
            this.statusDisplay = new StateDisplay(this.modulePm);
            this.statusDisplayFacade = new StateDisplayFacade(this.statusDisplay);
            this.templateModel = new TemplateModel();
            this.importModel = new ImportModel();
            this.importPanel = new EvvImportPanel((EvvImportPm)this.modulePm);
            this.frame.setContentPane(this.importPanel);
            this.selectImportTab(ImportTab.bordereau, null);
            Services.get(IActionService.class).tabChanged(0);
            this.frame.setJMenuBar(new ImportMenu().createMenuBar(this.modulePm));
        }
        this.modulePm.initialize();
    }

    @Override
    public StateDisplay getStatusDisplay() {
        Check.checkEDT();
        return this.statusDisplay;
    }

    @Override
    public StateDisplayFacade getStatusDisplayFacade() {
        Check.assertNotNull(this.statusDisplay);
        return this.statusDisplayFacade;
    }

    @Override
    public JFrame getMainFrame() {
        Check.checkEDT();
        return this.frame;
    }

    private void startCommitTimer() {
        this.timer = new Timer(1000, e2 -> {
            Check.checkEDT();
            if (this.focusInputField == null) {
                return;
            }
            if (!this.focusInputField.isVisible()) {
                return;
            }
            this.focusInputField.save();
        });
        this.timer.setRepeats(true);
        this.timer.start();
    }

    @Override
    public void clearFocusInputField() {
        this.focusInputField = null;
    }

    @Override
    public boolean isTabBordereauSelected() {
        if (this.importPanel == null) {
            return false;
        }
        return this.importPanel.isTabBordereauSelected();
    }

    @Override
    public boolean isTabReceiptSelected() {
        if (this.importPanel == null) {
            return false;
        }
        return this.importPanel.isTabReceiptSelected();
    }

    @Override
    public void shutdown() {
        this.timer.stop();
        if (this.frame == null) {
            return;
        }
        this.frame.dispose();
        Timer timer = new Timer(20000, e2 -> System.exit(0));
        timer.setRepeats(false);
        timer.start();
    }

    @Override
    public TemplateModel getTemplateModel() {
        return this.templateModel;
    }

    @Override
    public ImportModel getImportModel() {
        return this.importModel;
    }

    @Override
    public void refreshTemplateModel() {
        this.templateModel.refresh();
    }

    @Override
    public void refreshImportModel(boolean force) {
        this.importModel.refresh(force);
    }

    private void addFocusListener() {
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.addPropertyChangeListener(e2 -> {
            String prop = e2.getPropertyName();
            if ("focusOwner".equals(prop) && e2.getNewValue() instanceof IInputField) {
                this.focusInputField = (IInputField)e2.getNewValue();
            }
        });
    }

    @Override
    public void commitCurrentEditor() {
        if (this.focusInputField != null) {
            this.focusInputField.commit();
        }
    }

    @Override
    public void selectImportTab(ImportTab tab, String searchText) {
        switch (tab) {
            case bordereau: {
                this.importPanel.selectBordereau();
                break;
            }
            case receipts: {
                this.importPanel.selectDocs(searchText);
            }
        }
    }

    @Override
    public void selectExportTab(ExportTab exportTab) {
        switch (exportTab) {
            case template: {
                this.exportPanel.selectTemplate();
                break;
            }
            case imp: {
                this.exportPanel.selectImport();
                break;
            }
            case sendingList: {
                this.exportPanel.selectSendingList();
                break;
            }
            case header: {
                this.exportPanel.selectHeader();
                break;
            }
            case itemList: {
                this.exportPanel.selectItemList();
                break;
            }
            case forms: {
                this.exportPanel.selectForms();
            }
        }
    }

    @Override
    public void selectImportOrSending(String consigneeId) {
        if (this.importModel.selectFiles(consigneeId)) {
            this.selectExportTab(ExportTab.imp);
        } else {
            this.selectExportTab(ExportTab.header);
        }
    }

    @Override
    public void setHourGlassCursor(boolean value) {
        this.hourGlassCursor = value;
        if (this.hourGlassCursor) {
            this.setHourGlassCursor();
        } else {
            this.setNormalCursor();
        }
    }

    @Override
    public void setLinkCursor(boolean value) {
        if (this.hourGlassCursor) {
            return;
        }
        if (value) {
            this.setLinkCursor();
        } else {
            this.setNormalCursor();
        }
    }

    private void setHourGlassCursor() {
        for (Window current : JFrame.getWindows()) {
            current.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    private void setNormalCursor() {
        for (Window current : JFrame.getWindows()) {
            current.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void setLinkCursor() {
        for (Window current : JFrame.getWindows()) {
            current.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    @Override
    public void moduleChanged() {
        this.createUi();
        for (IModuleListener current : this.moduleListeners) {
            current.moduleChanged();
        }
    }

    @Override
    public IDisposable addModuleListener(IModuleListener listener) {
        return this.moduleListeners.add(listener);
    }

    public static enum ImportTab {
        bordereau,
        receipts;

    }

    public static enum ExportTab {
        template,
        imp,
        sendingList,
        header,
        itemList,
        forms;

    }
}

