/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.index;

import ch.transsoft.edec.model.infra.indexhandling.IndexBase;
import ch.transsoft.edec.model.infra.indexhandling.IndexEntryBase;
import ch.transsoft.edec.service.index.IArchiveChangeListener;
import ch.transsoft.edec.service.index.IIndexChangeListener;
import ch.transsoft.edec.service.index.IIndexServiceBase;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.disposable.IDisposable;
import ch.transsoft.edec.util.disposable.ListenerList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class IndexServiceBase<X extends IndexEntryBase<X>, T extends IndexBase<T, X>>
implements IIndexServiceBase<X, T> {
    private final ListenerList<IIndexChangeListener<X, T>> indexListeners = new ListenerList();
    private final ListenerList<IArchiveChangeListener<X, T>> archiveListeners = new ListenerList();
    private T index;
    private Collection<Integer> years;
    private final Map<Integer, T> archive = new HashMap<Integer, T>();

    @Override
    public IDisposable add(IIndexChangeListener<X, T> listener) {
        return this.indexListeners.add(listener);
    }

    @Override
    public IDisposable add(IArchiveChangeListener<X, T> listener) {
        return this.archiveListeners.add(listener);
    }

    private void notifyIndexChanged(T changed) {
        for (IIndexChangeListener<X, T> listener : this.indexListeners) {
            listener.changed(changed);
        }
    }

    private void notifyArchiveChanged(int year, T changed) {
        for (IArchiveChangeListener<X, T> listener : this.archiveListeners) {
            listener.changed(year, changed);
        }
    }

    @Override
    public void readArchive(Collection<Integer> years) {
        Check.checkEDT();
        for (Integer year : years) {
            this.readArchive(year);
        }
        this.years = years;
    }

    private void readArchive(Integer year) {
        if (this.archive.containsKey(year)) {
            this.notifyArchiveChanged(year, (IndexBase)this.archive.get(year));
        } else {
            this.reloadArchive(year);
        }
    }

    @Override
    public T getCachedIndex() {
        return this.index;
    }

    @Override
    public T getCachedArchive(int year) {
        IndexBase result = (IndexBase)this.archive.get(year);
        Check.assertNotNull(result);
        return (T)result;
    }

    protected abstract void reloadArchive(Integer var1);

    protected abstract void reloadIndex();

    @Override
    public void readIndex() {
        Check.checkEDT();
        if (this.index != null) {
            this.notifyIndexChanged(this.index);
        } else {
            this.reloadIndex();
        }
    }

    @Override
    public void archiveChanged(int year, T archivePart) {
        Check.checkEDT();
        this.archive.put(year, archivePart);
        this.notifyArchiveChanged(year, archivePart);
    }

    @Override
    public void indexChanged(T index) {
        Check.checkEDT();
        this.index = index;
        this.notifyIndexChanged(index);
    }

    @Override
    public void clearIndices() {
        this.archive.clear();
        this.notifyClearArchive();
        this.notifyClearIndex();
    }

    private void notifyClearIndex() {
        for (IIndexChangeListener<X, T> listener : this.indexListeners) {
            listener.clear();
        }
    }

    private void notifyClearArchive() {
        for (IArchiveChangeListener<X, T> listener : this.archiveListeners) {
            listener.clear();
        }
    }

    @Override
    public void reloadIndices() {
        this.reloadIndex();
        Check.assertNotNull(this.years, "years is null. readArchive(Set) was never called.");
        this.archive.clear();
        for (Integer year : this.years) {
            this.reloadArchive(year);
        }
    }
}

