/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.logging;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.logging.ILoggingService;
import java.awt.IllegalComponentStateException;

public class ExpoVitEdecExceptionHandler {
    public void handle(Throwable t) {
        if (ExpoVitEdecExceptionHandler.isIgnorableException(t)) {
            Services.get(ILoggingService.class).logSilent(t, "EDT-handler: ignorable Exception");
            return;
        }
        Services.get(ILoggingService.class).logUncaughtException(t, Thread.currentThread().getName());
    }

    public static boolean isIgnorableException(Throwable t) {
        if (t instanceof IllegalComponentStateException) {
            return true;
        }
        if (t.getStackTrace().length == 0) {
            return true;
        }
        if (!(t instanceof ArrayIndexOutOfBoundsException)) {
            return false;
        }
        if (t.getStackTrace()[0].getMethodName().equals("tabForCoordinate")) {
            return true;
        }
        if (t.getStackTrace()[0].getMethodName().equals("charsWidth")) {
            return true;
        }
        if (t.getStackTrace()[0].getMethodName().equals("mapTowardModel")) {
            return true;
        }
        return t.getStackTrace()[0].getMethodName().equals("elementAt") && t.getStackTrace()[1].getMethodName().equals("setSelectedPath");
    }
}

