/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.masterdata;

import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.infra.XMLReader;
import ch.transsoft.edec.model.masterdata.DataNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.JobUtil;
import ch.transsoft.edec.service.backend.jobs.ReadMasterDataJob;
import ch.transsoft.edec.service.backend.jobs.SaveMasterDataJob;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.config.IConfigServiceListener;
import ch.transsoft.edec.service.masterdata.IDataFile;
import ch.transsoft.edec.service.masterdata.IDataListener;
import ch.transsoft.edec.service.masterdata.IDataService;
import ch.transsoft.edec.service.masterdata.IMasterDataJob;
import ch.transsoft.edec.util.disposable.IDisposable;
import ch.transsoft.edec.util.disposable.ListenerList;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DataService
implements IDataService {
    private final Map<IDataFile<?>, DataNode<?>> masterDataMap = new HashMap();
    private final Map<IDataFile<?>, ListenerList<IDataListener<?>>> listenerMap = new HashMap();
    private final Map<IDataFile<?>, Set<IMasterDataJob<?>>> masterDataJobs = new HashMap();

    public DataService() {
        Services.get(IConfigService.class).add(new IConfigServiceListener(){

            @Override
            public void rootChanged() {
                DataService.this.masterDataMap.clear();
            }

            @Override
            public void modeChanged(boolean isDemo) {
            }

            @Override
            public void configurationChanged() {
            }
        });
    }

    private <T extends DataNode<T>> void fireMasterDataListener(T value) {
        for (IDataListener<T> listener : this.getListenerList(value.getDataFileType())) {
            listener.changed(value);
        }
    }

    @Override
    public <T extends DataNode<T>> T getMasterData(IDataFile<T> file) {
        DataNode<?> result = this.masterDataMap.get(file);
        if (result != null) {
            return (T)result;
        }
        this.loadData(file, false);
        return (T)((DataNode)NodeFactory.create(file.contentType()));
    }

    @Override
    public <T extends DataNode<T>> void loadData(IDataFile<T> file, boolean showWaitCursor) {
        ReadMasterDataJob<DataNode> job = new ReadMasterDataJob<DataNode>(file, showWaitCursor, this::setMasterData);
        Services.get(IBackendService.class).put(job);
    }

    @Override
    public <T extends DataNode<T>> void saveMasterData(T masterData) {
        Services.get(IBackendService.class).put(new SaveMasterDataJob(masterData));
        this.setMasterData(masterData);
    }

    @Override
    public void saveMasterDataNow(DataNode<?> masterData) {
        try {
            new SaveMasterDataJob(masterData).execute();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public <T extends DataNode<T>> void setMasterData(T masterData) {
        this.masterDataMap.put(masterData.getDataFileType(), masterData);
        this.fireMasterDataListener(masterData);
        Iterator<IMasterDataJob<?>> iter = this.getJobList(masterData.getDataFileType()).iterator();
        while (iter.hasNext()) {
            IMasterDataJob<?> current = iter.next();
            current.execute(masterData);
            iter.remove();
        }
    }

    @Override
    public <T extends DataNode<T>> IDisposable addDataListener(IDataFile<T> type, IDataListener<T> listener) {
        return this.getListenerList(type).add(listener);
    }

    private <T extends DataNode<T>> ListenerList<IDataListener<T>> getListenerList(IDataFile<T> dataFile) {
        ListenerList<IDataListener<T>> result = this.listenerMap.get(dataFile);
        if (result == null) {
            result = new ListenerList();
            this.listenerMap.put(dataFile, result);
        }
        return result;
    }

    @Override
    public boolean isCached(IDataFile<?> dataFile) {
        return this.masterDataMap.containsKey(dataFile);
    }

    @Override
    public <T extends DataNode<T>> T readSync(IDataFile<T> dataType) throws Exception {
        File file = JobUtil.getMasterDataPath(dataType, true);
        if (!file.exists()) {
            return (T)((DataNode)NodeFactory.create(dataType.contentType()));
        }
        XMLReader reader = new XMLReader();
        return (T)((DataNode)reader.read(new FileInputStream(file), dataType.contentType()));
    }

    @Override
    public <T extends DataNode<T>> void executeOnMasterdata(IDataFile<T> dataFile, IMasterDataJob<T> job) {
        if (this.isCached(dataFile)) {
            job.execute(this.getMasterData(dataFile));
            return;
        }
        this.loadData(dataFile, true);
        this.getJobList(dataFile).add(job);
    }

    private Set<IMasterDataJob<?>> getJobList(IDataFile<?> type) {
        Set<IMasterDataJob<?>> result = this.masterDataJobs.get(type);
        if (result == null) {
            result = new HashSet();
            this.masterDataJobs.put(type, result);
        }
        return result;
    }
}

