/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.masterdataezv.internal;

import ch.transsoft.edec.service.masterdataezv.DomainValue;
import ch.transsoft.edec.service.masterdataezv.internal.DescComparator;
import ch.transsoft.edec.service.masterdataezv.internal.Domain;
import ch.transsoft.edec.service.masterdataezv.internal.ValueComparator;
import ch.transsoft.edec.util.Check;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DomainDataBody {
    private Map<String, DomainValue> values = new HashMap<String, DomainValue>();
    private final Domain domain;

    public DomainDataBody(Domain domain) {
        Check.assertNotNull((Object)domain);
        this.domain = domain;
    }

    public DomainValue get(String valueName) {
        DomainValue result = this.values.get(valueName);
        if (result == null) {
            return this.createEmptyDomainValue(valueName);
        }
        return result;
    }

    private DomainValue createEmptyDomainValue(String valueName) {
        return DomainValue.createUnknown(valueName);
    }

    public void put(DomainValue domainValue) {
        this.values.put(domainValue.getKey(), domainValue);
    }

    public Iterator<DomainValue> iterator() {
        ArrayList<DomainValue> result = new ArrayList<DomainValue>();
        for (DomainValue current : this.values.values()) {
            if (this.domain.isFavorite(current.getKey())) continue;
            result.add(current);
        }
        Comparator<DomainValue> comparator = this.domain.isOrderByDesc() ? new DescComparator() : new ValueComparator();
        Collections.sort(result, comparator);
        int index = 0;
        for (String favorite : this.domain.getFavorites()) {
            result.add(index++, this.values.get(favorite));
        }
        return result.iterator();
    }

    public boolean containsValue(String value) {
        return this.values.containsKey(value);
    }

    public boolean exclude(String value) {
        return this.domain.exclude(value);
    }

    public Domain getDomain() {
        return this.domain;
    }
}

