/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.masterdataezv.internal;

import ch.transsoft.edec.service.form.forms.uz.ChamberTexts;
import ch.transsoft.edec.service.masterdataezv.DomainValue;
import ch.transsoft.edec.service.masterdataezv.IDomainData;
import ch.transsoft.edec.service.masterdataezv.IMasterDataEZVService;
import ch.transsoft.edec.service.masterdataezv.internal.CountryLoader;
import ch.transsoft.edec.service.masterdataezv.internal.CustomsOfficeLoader;
import ch.transsoft.edec.service.masterdataezv.internal.Domain;
import ch.transsoft.edec.service.masterdataezv.internal.DomainDataBody;
import ch.transsoft.edec.service.masterdataezv.internal.DomainDataHandle;
import ch.transsoft.edec.service.masterdataezv.internal.DomainLoader;
import ch.transsoft.edec.util.Check;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MasterDataEZVService
implements IMasterDataEZVService {
    private Map<Domain, DomainDataBody> domainData = new HashMap<Domain, DomainDataBody>();
    private Set<DomainValue> euZone = new HashSet<DomainValue>();
    private Set<DomainValue> securityZone = new HashSet<DomainValue>();

    public MasterDataEZVService() {
        new CountryLoader(this.domainData, this.securityZone, this.euZone).load();
        new CustomsOfficeLoader(this.domainData).load();
        new DomainLoader(this.domainData).load();
        this.addCorrespondenceLanguage();
        this.addDocumentLanguage();
        this.addGender();
        this.addEncoding();
        this.addImportKey();
        this.addChambersOfCommerce();
        this.addGrossupTypes();
        this.addModuleSelection();
        this.addDelimiter();
    }

    private void addImportKey() {
        DomainDataBody result = new DomainDataBody(Domain.grossupType);
        result.put(new DomainValue("0", "Keine Datenanreicherung", "Pas d'enrichissement des donn\u00e9s", "", ""));
        result.put(new DomainValue("1", "Artikelnummer", "Num\u00e9ro d'article", "", ""));
        result.put(new DomainValue("2", "Zolltarifnummer", "Code des marchandises", "", ""));
        this.domainData.put(Domain.importKey, result);
    }

    private void addGrossupTypes() {
        DomainDataBody result = new DomainDataBody(Domain.grossupType);
        result.put(new DomainValue("0", "Nicht hochrechnen", "Ne pas calculer", "", ""));
        result.put(new DomainValue("1", "Anzahl", "Nombre", "", ""));
        result.put(new DomainValue("2", "Zusatzmenge", "Quantit\u00e9 suppl\u00e9mentaire", "", ""));
        result.put(new DomainValue("3", "Brutogewicht", "Poids brut", "", ""));
        result.put(new DomainValue("4", "Nettogewicht", "Poids net", "", ""));
        this.domainData.put(Domain.grossupType, result);
    }

    private void addModuleSelection() {
        DomainDataBody result = new DomainDataBody(Domain.moduleSelection);
        result.put(new DomainValue("0", "e-dec Export", "e-dec Export", "", "", true));
        result.put(new DomainValue("1", "eVV Import", "DTE Import", "", "", true));
        this.domainData.put(Domain.moduleSelection, result);
    }

    private void addChambersOfCommerce() {
        DomainDataBody result = new DomainDataBody(Domain.chamberOfCommerce);
        result.put(ChamberTexts.AG);
        result.put(ChamberTexts.BE);
        result.put(ChamberTexts.BS);
        result.put(ChamberTexts.FL);
        result.put(ChamberTexts.FR);
        result.put(ChamberTexts.GE);
        result.put(ChamberTexts.GL);
        result.put(ChamberTexts.GR);
        result.put(ChamberTexts.JU);
        result.put(ChamberTexts.LU);
        result.put(ChamberTexts.NE);
        result.put(ChamberTexts.SG);
        result.put(ChamberTexts.SO);
        result.put(ChamberTexts.TG);
        result.put(ChamberTexts.TI);
        result.put(ChamberTexts.VD);
        result.put(ChamberTexts.VS);
        result.put(ChamberTexts.WI);
        result.put(ChamberTexts.ZH);
        this.domainData.put(Domain.chamberOfCommerce, result);
    }

    private void addCorrespondenceLanguage() {
        DomainDataBody result = new DomainDataBody(Domain.correspondenceLanguage);
        result.put(new DomainValue("de", "Deutsch", "Allemand", "Tedesco", "German"));
        result.put(new DomainValue("fr", "Franz\u00f6sisch", "Fran\u00e7ais", "Francese", "French"));
        this.domainData.put(Domain.correspondenceLanguage, result);
    }

    private void addDocumentLanguage() {
        DomainDataBody result = new DomainDataBody(Domain.documentLanguage);
        result.put(new DomainValue("--", "ExpoVit Sprache", "Langue d'ExpoVit", "Lingua da ExpoVit", "ExpoVit language"));
        result.put(new DomainValue("de", "Deutsch", "Allemand", "Tedesco", "German"));
        result.put(new DomainValue("fr", "Franz\u00f6sisch", "Fran\u00e7ais", "Francese", "French"));
        result.put(new DomainValue("it", "Italienisch", "Italien", "Italiano", "Italian"));
        this.domainData.put(Domain.documentLanguage, result);
    }

    private void addGender() {
        DomainDataBody result = new DomainDataBody(Domain.gender);
        result.put(new DomainValue("male", "Herr", "Monsieur", "Mr.", "Mr."));
        result.put(new DomainValue("female", "Frau", "Madame", "Ms.", "Ms."));
        this.domainData.put(Domain.gender, result);
    }

    private void addEncoding() {
        DomainDataBody result = new DomainDataBody(Domain.encoding);
        result.put(new DomainValue("ASCII"));
        result.put(new DomainValue("CP1252"));
        result.put(new DomainValue("ISO-8859-1"));
        result.put(new DomainValue("UTF-8"));
        this.domainData.put(Domain.encoding, result);
    }

    private void addDelimiter() {
        DomainDataBody result = new DomainDataBody(Domain.encoding);
        result.put(new DomainValue(";"));
        result.put(new DomainValue(","));
        this.domainData.put(Domain.delimiter, result);
    }

    @Override
    public IDomainData getDomainData(Domain domain, boolean allowEmpty) {
        Check.assertTrue(this.domainData.containsKey((Object)domain), "unknown domain: " + domain);
        return new DomainDataHandle(this.domainData.get((Object)domain), allowEmpty);
    }

    @Override
    public boolean isInSecurityZone(DomainValue country) {
        return this.securityZone.contains(country);
    }

    @Override
    public boolean isInEU(DomainValue country) {
        return this.euZone.contains(country);
    }
}

