/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.polling;

import ch.transsoft.edec.model.config.conf.license.LicenseInfo;
import ch.transsoft.edec.model.config.conf.license.LicenseStateEnum;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.action.IActionService;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.edecmail.GetStatusEmailListJob;
import ch.transsoft.edec.service.backend.jobs.evv.FetchAllEvvJob;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.service.polling.IPollingService;
import ch.transsoft.edec.service.webservices.bugreport.SendBugReportFacade;
import ch.transsoft.edec.service.webservices.customermgmt.CustomerLicenseState;
import ch.transsoft.edec.service.webservices.customermgmt.CustomerManagementFacade;
import ch.transsoft.edec.ui.action.FetchBordereauAction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.GregorianCalendar;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import org.openapitools.client.ApiException;

public class PollingService
implements IPollingService {
    private int moduleImportPollingCurrentMinue;

    @Override
    public void startEVVpolling() {
        if (!Services.get(IConfigService.class).getOptionInfo().getEvvInfo().getAutoDownloadAfterStartup().getValue().booleanValue()) {
            return;
        }
        Timer timer = new Timer(86400000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (!Services.get(IConfigService.class).registrationComplete()) {
                    return;
                }
                if (!Services.get(IConfigService.class).isModuleExport()) {
                    return;
                }
                Services.get(IBackendService.class).put(new FetchAllEvvJob(true));
                Services.get(ILoggingService.class).logSilent("eVVs fetched.");
            }
        });
        timer.setInitialDelay(300000);
        timer.start();
    }

    @Override
    public void startEdecMailPolling() {
        Timer timer = new Timer(3600000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (!Services.get(IConfigService.class).hasCertificate()) {
                    return;
                }
                if (!Services.get(IConfigService.class).isModuleExport()) {
                    return;
                }
                Services.get(IBackendService.class).put(new GetStatusEmailListJob());
                Services.get(ILoggingService.class).logSilent("StatusEmailList fetched.");
            }
        });
        timer.setInitialDelay(400000);
        timer.start();
    }

    @Override
    public void startStatePolling() {
        Timer timer = new Timer(86400000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (!Services.get(IConfigService.class).isRegistered()) {
                    return;
                }
                PollingService.this.fetchStateInfo();
            }
        });
        timer.setInitialDelay(5000);
        timer.start();
    }

    private void fetchStateInfo() {
        SwingWorker<CustomerLicenseState, Void> worker = new SwingWorker<CustomerLicenseState, Void>(){

            @Override
            protected CustomerLicenseState doInBackground() throws Exception {
                String guid = Services.get(IConfigService.class).getGuid();
                return CustomerManagementFacade.getStateInfo(guid);
            }

            @Override
            protected void done() {
                Services.get(ILoggingService.class).logSilent("StateInfo fetched.");
                try {
                    CustomerLicenseState result = (CustomerLicenseState)this.get();
                    PollingService.this.saveStateInfo(result);
                }
                catch (Exception e2) {
                    if (e2.getCause() instanceof ApiException && ((ApiException)e2.getCause()).getCode() == 400) {
                        return;
                    }
                    Services.get(ILoggingService.class).logSilent(e2, "failed to fetch StateInfo");
                }
                PollingService.this.handleLicenseInfo();
            }
        };
        worker.execute();
    }

    private void handleLicenseInfo() {
    }

    private void saveStateInfo(CustomerLicenseState serverState) {
        if (serverState.getLicenseStateEvvImport() == LicenseStateEnum.DEMO) {
            return;
        }
        LicenseInfo info = Services.get(IConfigService.class).getLicenseInfo();
        boolean save = false;
        if (info.getLicenseStateEdecExportValue() != serverState.getLicenseStateEdecExport()) {
            SendBugReportFacade.send(false, "Adjusting License-State e-dec  Export: " + info.getLicenseStateEdecExportValue() + " - " + serverState.getLicenseStateEdecExport());
            info.setLicenseStateEdecExportValue(serverState.getLicenseStateEdecExport());
            save = true;
        }
        if (info.getLicenseStateEvvExportRawValue() != serverState.getLicenseStateEvvExport()) {
            SendBugReportFacade.send(false, "Adjusting License-State eVV Export: " + info.getLicenseStateEvvExportValue() + " - " + serverState.getLicenseStateEvvExport());
            info.setLicenseStateEvvExportValue(serverState.getLicenseStateEvvExport());
            save = true;
        }
        if (info.getLicenseStateEvvImportValue() != serverState.getLicenseStateEvvImport()) {
            SendBugReportFacade.send(false, new RuntimeException("Exception for Stack Trace"), "Adjusting License-State eVV Import: " + info.getLicenseStateEvvImportValue() + " - " + serverState.getLicenseStateEvvImport());
            info.setLicenseStateEvvImportValue(serverState.getLicenseStateEvvImport());
            save = true;
        }
        if (info.getbillingStateValue() != serverState.getBillingState()) {
            info.getBillingState().setValue(serverState.getBillingState());
            save = true;
        }
        if (save) {
            Services.get(IConfigService.class).saveLicenseInfo(info);
        }
    }

    @Override
    public void startEvvImportPolling() {
        Timer timer = new Timer(20000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (!Services.get(IConfigService.class).hasLicenseForModuleImport()) {
                    return;
                }
                if (!Services.get(IConfigService.class).isModuleImport()) {
                    return;
                }
                if (!Services.get(IConfigService.class).getOptionInfo().getModuleImportInfo().getAutoDownload().getValue().booleanValue()) {
                    return;
                }
                if (PollingService.this.timeMachts()) {
                    Services.get(IActionService.class).getAction(FetchBordereauAction.class).actionPerformed(null);
                }
            }
        });
        timer.setInitialDelay(200000);
        timer.start();
        timer = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (!Services.get(IConfigService.class).hasLicenseForModuleImport()) {
                    return;
                }
                if (!Services.get(IConfigService.class).isModuleImport()) {
                    return;
                }
                if (Services.get(IConfigService.class).getOptionInfo().getModuleImportInfo().getDownloadAfterStartup().getValue().booleanValue()) {
                    Services.get(IActionService.class).getAction(FetchBordereauAction.class).actionPerformed(null);
                }
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    private boolean timeMachts() {
        String time = Services.get(IConfigService.class).getOptionInfo().getModuleImportInfo().getDownloadTime().getValue();
        if (!time.matches("\\d\\d\\:\\d\\d")) {
            return false;
        }
        String[] segs = time.split("\\:");
        GregorianCalendar now = new GregorianCalendar();
        int currentHour = now.get(11);
        int currentMinute = now.get(12);
        if (this.moduleImportPollingCurrentMinue == currentMinute) {
            return false;
        }
        this.moduleImportPollingCurrentMinue = currentMinute;
        return currentHour == Integer.parseInt(segs[0]) && currentMinute == Integer.parseInt(segs[1]);
    }
}

