/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.printer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.print.PrintService;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.Sides;

public class DeviceRegistry {
    private final Map<String, Boolean> duplexCache = new HashMap<String, Boolean>();
    private final Map<String, ArrayList<MediaTray>> mediaTrayCache = new HashMap<String, ArrayList<MediaTray>>();

    public boolean isDuplex(PrintService printService) {
        Boolean result = this.duplexCache.get(printService.getName());
        if (result == null) {
            result = printService.isAttributeValueSupported(Sides.TWO_SIDED_LONG_EDGE, null, null);
            this.duplexCache.put(printService.getName(), result);
        }
        return result;
    }

    public ArrayList<MediaTray> getMediaTrays(PrintService printService) {
        ArrayList<MediaTray> result = this.mediaTrayCache.get(printService.getName());
        if (result == null) {
            result = new ArrayList();
            for (Media current : (Media[])printService.getSupportedAttributeValues(Media.class, null, null)) {
                if (!(current instanceof MediaTray)) continue;
                result.add((MediaTray)current);
            }
            this.mediaTrayCache.put(printService.getName(), result);
        }
        return result;
    }
}

