/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.smtp;

import ch.transsoft.edec.model.config.pref.mail.MailPreferenceInfo;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.logging.LoggingService;
import ch.transsoft.edec.service.smtp.ISmtpService;
import ch.transsoft.edec.service.webservices.mail.CarrierMail;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import ch.transsoft.edec.ui.dialog.mail.model.AttachmentEntry;
import jakarta.activation.DataHandler;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class SmtpService
implements ISmtpService {
    public static Session getSession(MailPreferenceInfo config) {
        Properties props = new Properties();
        SmtpService.setProperty("mail.smtp.host", config.getHost(), props);
        SmtpService.setProperty("mail.smtp.port", config.getPort(), props);
        props.put("mail.smtp.timeout", "20000");
        props.put("mail.smtp.connectiontimeout", "20000");
        if (config.getUseSSL().getValue().booleanValue()) {
            props.put("mail.smtp.auth", "true");
            props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        }
        if (config.getUseTLS().getValue().booleanValue()) {
            props.put("mail.smtp.auth", "true");
            props.put("mail.smtp.ssl.protocols", "TLSv1.2 TLSv1.3");
            props.put("mail.smtp.starttls.enable", "true");
        }
        if (config.getUser().isInitialized() || config.getPassword().isInitialized()) {
            return Session.getInstance(props, SmtpService.getAuthenticator(config.getUser().getValue(), config.getPassword().getValue()));
        }
        return Session.getInstance(props);
    }

    private static Authenticator getAuthenticator(final String username, final String password) {
        return new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password);
            }
        };
    }

    private static void setProperty(String propertyName, StringNode value, Properties props) {
        if (!value.isInitialized()) {
            throw new IllegalArgumentException("No Value for Property " + propertyName);
        }
        props.setProperty(propertyName, value.getValue());
    }

    @Override
    public boolean send(CarrierMail mail, ListNode<AttachmentEntry> attachments, Object attachmentContext) {
        MailPreferenceInfo config = Services.get(IConfigService.class).getPreferences().getMailPreferenceInfo();
        try {
            MimeMessage message = this.createMessage(config, mail.getToAddresses(), mail.getCcAddresses(), mail.getBccAddresses(), mail.getSubject());
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart(this.createBody(mail));
            for (CarrierMail.Attachment attachment : mail.getAttachments()) {
                multipart.addBodyPart(this.createAttachment(attachment));
            }
            message.setContent(multipart);
            Transport.send(message);
            return true;
        }
        catch (Exception e2) {
            DialogUtil.showErrorDialog("Error sending e-mail", LoggingService.getExceptionMessage(e2));
            return false;
        }
    }

    public MimeMessage createMessage(MailPreferenceInfo config, List<String> to, List<String> cc, List<String> bcc, String subject) throws MessagingException {
        MimeMessage message = new MimeMessage(SmtpService.getSession(config));
        if (!config.getSenderEmailAdress().isInitialized()) {
            throw new IllegalArgumentException("Sender E-Mail Address not set");
        }
        message.setFrom(new InternetAddress(config.getSenderEmailAdress().getValue()));
        this.addRecipients(Message.RecipientType.TO, to, message);
        this.addRecipients(Message.RecipientType.CC, cc, message);
        this.addRecipients(Message.RecipientType.BCC, bcc, message);
        message.setSubject(subject, "ISO-8859-1");
        message.setSentDate(new Date());
        return message;
    }

    private void addRecipients(Message.RecipientType type, List<String> addresses, MimeMessage message) throws MessagingException {
        for (String current : addresses) {
            if (current.isEmpty()) continue;
            message.addRecipient(type, new InternetAddress(current));
        }
    }

    private BodyPart createAttachment(CarrierMail.Attachment attachment) throws MessagingException {
        MimeBodyPart result = new MimeBodyPart();
        ByteArrayDataSource source = new ByteArrayDataSource(attachment.getData(), attachment.getMime());
        result.setDataHandler(new DataHandler(source));
        result.setFileName(attachment.getFileName());
        return result;
    }

    private BodyPart createBody(CarrierMail mail) throws MessagingException {
        MimeBodyPart result = new MimeBodyPart();
        result.setContent(mail.getContent(), "text/plain;charset=ISO-8859-1");
        return result;
    }

    private String createToAddress(CarrierMail mailInfo) {
        StringBuilder result = new StringBuilder();
        for (int i2 = 0; i2 < mailInfo.getToAddresses().size(); ++i2) {
            if (i2 != 0) {
                result.append(";");
            }
            result.append(mailInfo.getToAddresses().get(i2));
        }
        return result.toString();
    }
}

