/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.text.internal;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.service.text.ITextService;
import ch.transsoft.edec.service.text.ITextServiceListener;
import ch.transsoft.edec.service.text.internal.Text;
import ch.transsoft.edec.service.text.internal.TextLoader;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.FileUtil;
import ch.transsoft.edec.util.disposable.ListenerList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;

public class TextService
implements ITextService {
    private final Map<Integer, Text> texts = new HashMap<Integer, Text>();
    private ITextService.Language currentLanguage;
    private final ListenerList<ITextServiceListener> listeners = new ListenerList();

    public TextService() {
        this.currentLanguage = this.readCurrentLanguage();
        new TextLoader(this.texts).load();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ITextService.Language readCurrentLanguage() {
        File file = this.getLanguageFile();
        if (!file.exists()) {
            return this.getDefaultLanguage();
        }
        try (BufferedReader br = FileUtil.createFileReader(file);){
            String line = br.readLine();
            if (line == null) {
                ITextService.Language language = this.getDefaultLanguage();
                return language;
            }
            if (line.equals(ITextService.Language.de.name())) {
                ITextService.Language language = ITextService.Language.de;
                return language;
            }
            if (line.equals(ITextService.Language.fr.name())) {
                ITextService.Language language = ITextService.Language.fr;
                return language;
            }
            ITextService.Language language = this.getDefaultLanguage();
            return language;
        }
        catch (Exception e2) {
            return ITextService.Language.de;
        }
    }

    private ITextService.Language getDefaultLanguage() {
        String lan = System.getProperty("user.language");
        if (lan == null) {
            return ITextService.Language.de;
        }
        if (lan.isEmpty()) {
            return ITextService.Language.de;
        }
        if (lan.contains("fr")) {
            return ITextService.Language.fr;
        }
        return ITextService.Language.de;
    }

    private File getLanguageFile() {
        return Services.get(IConfigService.class).getLanguageFilePath();
    }

    @Override
    public String getText(int id) {
        return this.getText(this.getCurrentLanguage(), id);
    }

    @Override
    public String getText(ITextService.Language language, int id) {
        Text result = this.texts.get(id);
        if (result == null) {
            return Integer.toString(id);
        }
        return result.getText(language);
    }

    @Override
    public ITextService.Language getCurrentLanguage() {
        return this.currentLanguage;
    }

    @Override
    public void setCurrentLanguage(ITextService.Language language) {
        Check.assertNotNull((Object)language);
        this.currentLanguage = language;
        this.saveLanguage();
        for (ITextServiceListener listener : this.listeners) {
            listener.languageChanged();
        }
        Services.get(IGuiService.class).createUi();
    }

    private void saveLanguage() {
        File file = this.getLanguageFile();
        try (FileWriter writer = FileUtil.createFileWriter(file);){
            writer.write(this.currentLanguage.name());
        }
        catch (Exception e2) {
            Services.get(ILoggingService.class).logSilent(e2, "Failed to save language-file");
        }
    }

    @Override
    public void add(ITextServiceListener listener) {
        this.listeners.add(listener);
    }
}

