/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.validate.rules;

import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsData;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsItem;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.validate.rules.GoodsItemRuleBase;

public class BeipackPerItem
extends GoodsItemRuleBase {
    @Override
    protected void doValidate(GoodsItem itemBefore, GoodsItem item, GoodsData data) {
        if (!item.getGoodsData().isBeipack()) {
            return;
        }
        if (item.getGoodsData().getQuantity().isInitialized()) {
            this.addError(item.getGoodsData().getQuantity(), Services.getText(930));
        }
        if (itemBefore == null) {
            this.addError(item.getGoodsData().getPackagingType(), Services.getText(931));
            return;
        }
        if (itemBefore.getGoodsData().isBeipack()) {
            return;
        }
        if (!itemBefore.getGoodsData().getQuantity().isInitialized() || itemBefore.getGoodsData().getQuantity().getValue() == 0L) {
            this.addError(itemBefore.getGoodsData().getQuantity(), Services.getText(932));
        }
        if (!itemBefore.getGoodsData().getPackagingReferenceNumber().isInitialized()) {
            this.addError(itemBefore.getGoodsData().getPackagingReferenceNumber(), Services.getText(933));
        }
    }
}

