/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.validate.rules;

import ch.transsoft.edec.model.infra.node.SelectionNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsData;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsItem;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.Permit;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.validate.rules.GoodsItemRuleBase;

public class PermitDetail
extends GoodsItemRuleBase {
    @Override
    protected void doValidate(GoodsItem itemBefore, GoodsItem item, GoodsData data) {
        for (Permit permit : item.getPermits().getPermitList()) {
            this.validate(permit.getPermitDetailKey(), permit.getPermitDetailValue());
            this.validate(permit.getPermitDetailKey2(), permit.getPermitDetailValue2());
        }
        if (data.getVOCQuantity().isInitialized() && !data.getRefundType().isInitialized()) {
            this.addError(data.getVOCQuantity(), Services.getText(954));
            this.addError(data.getRefundType(), Services.getText(954));
        }
    }

    private void validate(SelectionNode key, StringNode value) {
        if (!key.isInitialized() && !value.isInitialized()) {
            return;
        }
        if (!key.isInitialized()) {
            this.addError(key, Services.getText(1311));
        }
        if (!value.isInitialized()) {
            this.addError(value, Services.getText(1311));
        }
    }
}

