/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.validate.rules;

import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.validate.ErrorList;
import ch.transsoft.edec.service.validate.RuleBase;
import ch.transsoft.edec.service.validate.rules.BeipackPerItem;
import ch.transsoft.edec.service.validate.rules.CheckDates;
import ch.transsoft.edec.service.validate.rules.ContainersNotEmpty;
import ch.transsoft.edec.service.validate.rules.CorrectionCode;
import ch.transsoft.edec.service.validate.rules.E001;
import ch.transsoft.edec.service.validate.rules.E002c;
import ch.transsoft.edec.service.validate.rules.E003;
import ch.transsoft.edec.service.validate.rules.E004;
import ch.transsoft.edec.service.validate.rules.E134;
import ch.transsoft.edec.service.validate.rules.E138;
import ch.transsoft.edec.service.validate.rules.Eur1HasAtLeastOnePosition;
import ch.transsoft.edec.service.validate.rules.GoodsItemDescription;
import ch.transsoft.edec.service.validate.rules.ListSizeCheck;
import ch.transsoft.edec.service.validate.rules.MandatoryFields;
import ch.transsoft.edec.service.validate.rules.NumbersAreNonNegative;
import ch.transsoft.edec.service.validate.rules.PermitDetail;
import ch.transsoft.edec.service.validate.rules.RepairMigrationValidation;
import ch.transsoft.edec.service.validate.rules.StatValueBiggerThanOneFranc;
import ch.transsoft.edec.service.validate.rules.TraderDeclarationNumberFormat;
import ch.transsoft.edec.service.validate.rules.UidConsignorIsValid;
import ch.transsoft.edec.service.validate.rules.VOCQuantity;
import ch.transsoft.edec.service.validate.rules.ValuesAreInDomain;
import ch.transsoft.edec.service.validate.rules.VatConsignorIsValid;
import java.util.ArrayList;
import java.util.List;

public class Validator {
    private final List<RuleBase> rules = new ArrayList<RuleBase>();

    public Validator() {
        this.rules.add(new MandatoryFields());
        this.rules.add(new ListSizeCheck());
        this.rules.add(new CheckDates());
        this.rules.add(new NumbersAreNonNegative());
        this.rules.add(new ValuesAreInDomain());
        this.rules.add(new GoodsItemDescription());
        this.rules.add(new ContainersNotEmpty());
        this.rules.add(new TraderDeclarationNumberFormat());
        this.rules.add(new BeipackPerItem());
        this.rules.add(new Eur1HasAtLeastOnePosition());
        this.rules.add(new VOCQuantity());
        this.rules.add(new StatValueBiggerThanOneFranc());
        this.rules.add(new VatConsignorIsValid());
        this.rules.add(new PermitDetail());
        this.rules.add(new E001());
        this.rules.add(new E002c());
        this.rules.add(new E003());
        this.rules.add(new E004());
        this.rules.add(new E134());
        this.rules.add(new E138());
        this.rules.add(new RepairMigrationValidation());
        this.rules.add(new UidConsignorIsValid());
    }

    public ErrorList computeErrors(Sending sending, boolean forSending) {
        ErrorList result = new ErrorList();
        if (forSending) {
            new CorrectionCode().validate(sending, result);
        }
        for (RuleBase rule : this.rules) {
            rule.validate(sending, result);
        }
        return result;
    }
}

