/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.webservices.bugreport;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.service.webservices.BackendConfiguration;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.SystemUtil;
import ch.transsoft.edec.util.TextUtil;
import java.net.UnknownHostException;
import org.openapitools.client.api.SendBugReportControllerApi;
import org.openapitools.client.model.BugReportRequest;

public final class SendBugReportFacade {
    private static SendBugReportControllerApi getApi() {
        return new SendBugReportControllerApi(BackendConfiguration.getApiClient());
    }

    public static void send(boolean severe, Throwable exception, String ... messages) {
        String message = Check.createMessage(messages);
        String stackTrace = TextUtil.getStackTrace(exception);
        SendBugReportFacade.send(severe, message + "\n\n" + stackTrace);
    }

    public static void send(boolean severe, Throwable exception) {
        if (SendBugReportFacade.ignoreException(exception)) {
            return;
        }
        SendBugReportFacade.send(severe, TextUtil.getStackTrace(exception));
    }

    private static boolean ignoreException(Throwable exception) {
        if (exception instanceof UnknownHostException) {
            return true;
        }
        return exception.getCause() instanceof UnknownHostException;
    }

    public static Thread send(boolean severe, String message) {
        try {
            String guid = Services.get(IConfigService.class).getGuid();
            String version = SystemUtil.getDebugVersionString();
            Thread myThread = new Thread(() -> SendBugReportFacade.sendInBackground(severe, guid, version, message));
            myThread.setUncaughtExceptionHandler((t, e2) -> e2.printStackTrace());
            myThread.start();
            return myThread;
        }
        catch (Exception e3) {
            e3.printStackTrace();
            throw new RuntimeException();
        }
    }

    private static void sendInBackground(boolean severe, String guid, String version, String message) {
        message = (severe ? "Error: " : "Warning: ") + (String)message;
        try {
            SendBugReportControllerApi api = SendBugReportFacade.getApi();
            BugReportRequest request = new BugReportRequest();
            request.setGuid(guid);
            request.setVersion(version);
            request.setException((String)message);
            api.processBugMail(request);
        }
        catch (Exception e2) {
            Services.get(ILoggingService.class).logSilent(e2, "Failed to send error-mail.");
        }
    }
}

