/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.webservices.customermgmt;

import ch.transsoft.edec.model.config.conf.license.AddressInfo;
import ch.transsoft.edec.model.config.conf.license.BillingInfo;
import ch.transsoft.edec.model.config.conf.license.ContactInfo;
import ch.transsoft.edec.model.config.conf.license.RegistrationInfo;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.service.webservices.BackendConfiguration;
import ch.transsoft.edec.service.webservices.LicenseAlreadyBoughtException;
import ch.transsoft.edec.service.webservices.RestUtil;
import ch.transsoft.edec.service.webservices.UnknownCustomsDeclarationNumberException;
import ch.transsoft.edec.service.webservices.UnknownGuidException;
import ch.transsoft.edec.service.webservices.customermgmt.CrmBillingData;
import ch.transsoft.edec.service.webservices.customermgmt.CustomerLicenseState;
import ch.transsoft.edec.service.webservices.customermgmt.CustomsCertificate;
import ch.transsoft.edec.service.webservices.customermgmt.StatusMailState;
import ch.transsoft.edec.util.EnumUtil;
import java.util.List;
import org.openapitools.client.ApiException;
import org.openapitools.client.api.CustomerControllerApi;
import org.openapitools.client.model.AddressDto;
import org.openapitools.client.model.BillingDto;
import org.openapitools.client.model.BuyLicenseRequest;
import org.openapitools.client.model.ContactDto;
import org.openapitools.client.model.CustomerResponse;
import org.openapitools.client.model.CustomerUpdateRequest;
import org.openapitools.client.model.CustomsInformationRequest;
import org.openapitools.client.model.GetStateInfoRequest;
import org.openapitools.client.model.GuidRequest;
import org.openapitools.client.model.NewCustomerRequest;
import org.openapitools.client.model.PollStatusDto;
import org.openapitools.client.model.PollStatusRequest;
import org.openapitools.client.model.StateResponse;
import org.openapitools.client.model.TransactionReportRequest;

public final class CustomerManagementFacade {
    private static CustomerControllerApi getApi() {
        return new CustomerControllerApi(BackendConfiguration.getApiClient());
    }

    private static String getUserName() {
        return Services.get(IConfigService.class).getUserName();
    }

    private static String getRootFolderAsString() {
        return Services.get(IConfigService.class).getRootFolder().getPath();
    }

    public static CustomsCertificate getCertificate(String guid) throws UnknownGuidException {
        CustomerControllerApi api = CustomerManagementFacade.getApi();
        GuidRequest guidRequest = new GuidRequest();
        guidRequest.setGuid(guid);
        return new CustomsCertificate(RestUtil.executeAndHandleUnknownGuid(() -> api.getCertificate(guidRequest)));
    }

    public static void setCustomsInformation(String guid, String uid, String password) throws UnknownGuidException {
        CustomerControllerApi api = CustomerManagementFacade.getApi();
        CustomsInformationRequest request = new CustomsInformationRequest();
        request.setGuid(guid);
        request.setUid(uid);
        request.setCertificatePassword(password);
        request.setRootFolder(CustomerManagementFacade.getRootFolderAsString());
        request.setUserName(CustomerManagementFacade.getUserName());
        RestUtil.executeAndHandleUnknownGuid(() -> {
            api.setCustomsInformation(request);
            return Void.TYPE;
        });
    }

    public static void buyLicenseEdecExport(String guid) throws UnknownGuidException, LicenseAlreadyBoughtException {
        CustomerControllerApi api = CustomerManagementFacade.getApi();
        BuyLicenseRequest request = new BuyLicenseRequest();
        request.setGuid(guid);
        request.setRootFolder(CustomerManagementFacade.getRootFolderAsString());
        request.setUserName(CustomerManagementFacade.getUserName());
        RestUtil.executeAndHandleUnknownGuidAndLicenseAlreadyBought(() -> {
            api.buyLicenseEdecExport(request);
            return null;
        });
    }

    public static void buyLicenseEvvExport(String guid) throws UnknownGuidException, LicenseAlreadyBoughtException {
        CustomerControllerApi api = CustomerManagementFacade.getApi();
        BuyLicenseRequest request = new BuyLicenseRequest();
        request.setGuid(guid);
        request.setRootFolder(CustomerManagementFacade.getRootFolderAsString());
        request.setUserName(CustomerManagementFacade.getUserName());
        RestUtil.executeAndHandleUnknownGuidAndLicenseAlreadyBought(() -> {
            api.buyLicenseEvvExport(request);
            return null;
        });
    }

    public static void buyLicenseEvvImport(String guid) throws UnknownGuidException, LicenseAlreadyBoughtException {
        CustomerControllerApi api = CustomerManagementFacade.getApi();
        BuyLicenseRequest request = new BuyLicenseRequest();
        request.setGuid(guid);
        request.setRootFolder(CustomerManagementFacade.getRootFolderAsString());
        request.setUserName(CustomerManagementFacade.getUserName());
        RestUtil.executeAndHandleUnknownGuidAndLicenseAlreadyBought(() -> {
            api.buyLicenseImport(request);
            return null;
        });
    }

    public static String register(RegistrationInfo info) throws ApiException {
        CustomerControllerApi api = CustomerManagementFacade.getApi();
        NewCustomerRequest request = new NewCustomerRequest();
        NewCustomerRequest.LanguageEnum lan = CustomerManagementFacade.getLangEnumRegistration(info.getLanguage().getValue().getKey());
        AddressDto mainAddress = CustomerManagementFacade.createaAddressDto(info.getMainAddress());
        ContactDto mainContact = CustomerManagementFacade.createContactDto(info.getMainContact());
        BillingDto billingData = CustomerManagementFacade.createBillingDto(info.getBillingInfo());
        request.setLanguage(lan);
        request.setAddress(mainAddress);
        request.setContact(mainContact);
        request.setBillingData(billingData);
        request.setRootFolder(CustomerManagementFacade.getRootFolderAsString());
        request.setUserName(CustomerManagementFacade.getUserName());
        CustomerResponse response = RestUtil.execute(() -> api.registerNewCustomer(request));
        return response.getGuid();
    }

    public static CrmBillingData update(String guid, RegistrationInfo info) throws UnknownGuidException {
        CustomerControllerApi api = CustomerManagementFacade.getApi();
        CustomerUpdateRequest request = new CustomerUpdateRequest();
        request.setRootFolder(CustomerManagementFacade.getRootFolderAsString());
        request.setUserName(CustomerManagementFacade.getUserName());
        request.setGuid(guid);
        request.setLanguage(CustomerManagementFacade.getLangEnumUpdate(info.getLanguage().getValue().getKey()));
        request.setAddress(CustomerManagementFacade.createaAddressDto(info.getMainAddress()));
        request.setContact(CustomerManagementFacade.createContactDto(info.getMainContact()));
        request.setBillingData(CustomerManagementFacade.createBillingDto(info.getBillingInfo()));
        CustomerResponse response = RestUtil.executeAndHandleUnknownGuid(() -> api.updateCustomer(request));
        return new CrmBillingData(response.getBillingData());
    }

    public static void reportTransactionExport(String guid, String customsDeclarationNumber, int module, boolean productive) throws UnknownGuidException {
        CustomerControllerApi api = CustomerManagementFacade.getApi();
        TransactionReportRequest request = new TransactionReportRequest();
        request.setGuid(guid);
        request.setCustomsDeclarationNumber(customsDeclarationNumber);
        request.setModule(module);
        request.setProductive(productive);
        RestUtil.executeAndHandleUnknownGuid(() -> {
            api.reportTransactionExport(request);
            return Void.TYPE;
        });
        Services.get(ILoggingService.class).logSilent("OT logged: " + customsDeclarationNumber);
    }

    public static void reportTransactionImport(String guid, String customsDeclarationNumber, boolean productive) throws UnknownGuidException {
        CustomerControllerApi api = CustomerManagementFacade.getApi();
        TransactionReportRequest request = new TransactionReportRequest();
        request.setGuid(guid);
        request.setCustomsDeclarationNumber(customsDeclarationNumber);
        request.setProductive(productive);
        request.setModule(3);
        RestUtil.executeAndHandleUnknownGuid(() -> {
            api.reportTransactionExport(request);
            return Void.TYPE;
        });
        Services.get(ILoggingService.class).logSilent("OTI logged: " + customsDeclarationNumber);
    }

    public static List<String> getStatusEmailList(String guid) throws UnknownGuidException {
        CustomerControllerApi api = CustomerManagementFacade.getApi();
        GuidRequest request = new GuidRequest();
        request.setGuid(guid);
        return RestUtil.executeAndHandleUnknownGuid(() -> api.getStatusEmailList(request));
    }

    public static StatusMailState pollStatusEmail(String guid, String customsDeclarationNumber) throws UnknownGuidException, UnknownCustomsDeclarationNumberException {
        CustomerControllerApi api = CustomerManagementFacade.getApi();
        PollStatusRequest request = new PollStatusRequest();
        request.setGuid(guid);
        request.setCustomsDeclarationNumber(customsDeclarationNumber);
        PollStatusDto response = RestUtil.executeAndHandleUnknownGuidAndUnknownCustomDeclaration(() -> api.pollStatusEmail(request));
        return new StatusMailState(response);
    }

    public static CustomerLicenseState getStateInfo(String guid) throws UnknownGuidException {
        CustomerControllerApi api = CustomerManagementFacade.getApi();
        GetStateInfoRequest request = new GetStateInfoRequest();
        request.setGuid(guid);
        StateResponse response = RestUtil.executeAndHandleUnknownGuid(() -> api.getStateInfo(request));
        return new CustomerLicenseState(response);
    }

    private static NewCustomerRequest.LanguageEnum getLangEnumRegistration(String langaugeKey) {
        String enumName = langaugeKey.equals("fr") ? "FR" : "DE";
        return EnumUtil.getEnum(NewCustomerRequest.LanguageEnum.class, enumName, NewCustomerRequest.LanguageEnum.DE);
    }

    private static CustomerUpdateRequest.LanguageEnum getLangEnumUpdate(String langaugeKey) {
        String enumName = langaugeKey.equals("fr") ? "FR" : "DE";
        return EnumUtil.getEnum(CustomerUpdateRequest.LanguageEnum.class, enumName, CustomerUpdateRequest.LanguageEnum.DE);
    }

    private static BillingDto createBillingDto(BillingInfo billingInfo) {
        BillingDto result = new BillingDto();
        result.setElectronicBill(billingInfo.getElectronicBill().getValue());
        result.setBillMail(billingInfo.getBillEmail().getValue());
        result.setBillMailCc(billingInfo.getBillEmailCc().getValue());
        result.setInvoiceMail(billingInfo.getInvoiceMail().getValue());
        return result;
    }

    private static AddressDto createaAddressDto(AddressInfo address) {
        AddressDto result = new AddressDto();
        result.setCompany(address.getCompanyName().getValue());
        if (address.getAddition().isInitialized()) {
            result.setAddition(address.getAddition().getValue());
        }
        result.setStreet(address.getStreet().getValue());
        if (address.getBox().isInitialized()) {
            result.setPostbox(address.getBox().getValue());
        }
        result.setZipCode(address.getZip().getValue());
        result.setCity(address.getCity().getValue());
        result.setCountry(address.getCountry().getValue().getKey());
        return result;
    }

    private static ContactDto createContactDto(ContactInfo mainContact) {
        ContactDto result = new ContactDto();
        result.setFirst(mainContact.getFirstName().getValue());
        result.setLast(mainContact.getLastName().getValue());
        result.setGender(mainContact.getGender().getValue().getKey());
        result.setPhone(mainContact.getPhone().getValue());
        result.setEmail(mainContact.getEmail().getValue());
        if (mainContact.getFunction().isInitialized()) {
            result.setFunction(mainContact.getFunction().getValue());
        }
        return result;
    }
}

