/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.webservices.mail;

import ch.transsoft.edec.service.webservices.BackendConfiguration;
import ch.transsoft.edec.service.webservices.RestUtil;
import ch.transsoft.edec.service.webservices.UnknownGuidException;
import ch.transsoft.edec.service.webservices.mail.CarrierMail;
import java.util.stream.Collectors;
import org.openapitools.client.api.SendMailToCarrierControllerApi;
import org.openapitools.client.model.AttachmentDto;
import org.openapitools.client.model.CarrierMailDto;
import org.openapitools.client.model.MailRequest;

public final class SendMailToCarrierFacade {
    private static SendMailToCarrierControllerApi getApi() {
        return new SendMailToCarrierControllerApi(BackendConfiguration.getApiClient());
    }

    public static void send(String guid, CarrierMail mail) throws UnknownGuidException {
        SendMailToCarrierControllerApi api = SendMailToCarrierFacade.getApi();
        MailRequest request = new MailRequest();
        request.setGuid(guid);
        request.setMail(SendMailToCarrierFacade.toDto(mail));
        RestUtil.executeAndHandleUnknownGuid(() -> {
            api.send(request);
            return Void.TYPE;
        });
    }

    private static AttachmentDto toAttachmentDto(CarrierMail.Attachment attachment) {
        AttachmentDto dto = new AttachmentDto();
        dto.setFileName(attachment.getFileName());
        dto.setData(attachment.getData());
        dto.setMime(attachment.getMime());
        return dto;
    }

    private static CarrierMailDto toDto(CarrierMail mail) {
        CarrierMailDto dto = new CarrierMailDto();
        dto.setToAddresses(mail.getToAddresses());
        dto.setCcAddresses(mail.getCcAddresses());
        dto.setBccAddresses(mail.getBccAddresses());
        dto.setReplyAddress(mail.getReplyAddress());
        dto.setSubject(mail.getSubject());
        dto.setContent(mail.getContent());
        dto.setAttachments(mail.getAttachments().stream().map(SendMailToCarrierFacade::toAttachmentDto).collect(Collectors.toList()));
        return dto;
    }
}

