/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.action;

import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.infra.node.FileNode;
import ch.transsoft.edec.model.sending.EVVState;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.action.LockedActionBase;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.sending.CreateSendingFromSendingEntry;
import ch.transsoft.edec.service.backend.jobs.sending.SendingEntry;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.ezv.evv.EvvResponse;
import ch.transsoft.edec.service.gui.GuiService;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import ch.transsoft.edec.util.DocumentUtil;
import ch.transsoft.edec.util.FileChooserUtil;
import ch.transsoft.edec.util.FileUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EvvFileImportForModuleExportAction
extends LockedActionBase {
    public EvvFileImportForModuleExportAction() {
        super(Services.getText(4800));
        this.disableIfNoEvvExportLicense(141, 4800);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        FileNode lastImportFolder = Services.get(IConfigService.class).getPreferences().getLastUsedFolders().getEvvFileImportFolder();
        File[] files = FileChooserUtil.chooseFiles(lastImportFolder.getValue(), Services.getText(4801), null, null, "XML");
        if (files.length == 0) {
            return;
        }
        lastImportFolder.setValue(files[0].getParentFile());
        Services.get(IConfigService.class).savePreferences();
        Services.get(IGuiService.class).selectExportTab(GuiService.ExportTab.sendingList);
        for (File file : files) {
            if (!file.exists()) continue;
            try {
                this.readEvv(file);
            }
            catch (Exception e2) {
                Services.get(ILoggingService.class).logAndReport(e2, Services.getText(4802));
            }
        }
    }

    private void readEvv(File file) throws IOException {
        Document doc;
        try {
            doc = DocumentUtil.readXmlDoc(file);
        }
        catch (Exception e2) {
            DialogUtil.showWarningDialog(Services.getText(600), Services.getText(4802) + ": " + file);
            return;
        }
        if (doc.getElementsByTagName("taxationDecisionExport").getLength() != 1) {
            DialogUtil.showWarningDialog(Services.getText(600), Services.getText(4803) + ": " + file);
            return;
        }
        Sending sending = this.createSending(doc, file);
        SendingEntry sendingEntry = new SendingEntry();
        sendingEntry.sending = sending;
        sendingEntry.evv = this.createEvvResponse(file);
        Services.get(IBackendService.class).put(new CreateSendingFromSendingEntry(sendingEntry), true);
    }

    private EvvResponse createEvvResponse(File file) throws IOException {
        return new EvvResponse(FileUtil.getFileAsByteArray(file), null);
    }

    private Sending createSending(Document doc, File file) {
        Sending sending = NodeFactory.create(Sending.class);
        sending.getState().setEvvState(EVVState.complete);
        sending.addHistoryEntry("Created from evv-file " + file);
        DocumentUtil.setString(sending.getGoodsDeclaration().getTraderDeclarationNumber(), doc, "traderDeclarationNumber");
        DocumentUtil.setString(sending.getGoodsDeclaration().getTraderReference(), doc, "traderReference");
        DocumentUtil.setString(sending.getGoodsDeclaration().getCustomsDeclarationNumber(), doc, "documentNumber");
        DocumentUtil.setInteger(sending.getGoodsDeclaration().getCustomsDeclarationVersion(), doc.getDocumentElement(), "documentVersion");
        DocumentUtil.setAcceptanceDate(sending.getCreationDate(), doc);
        DocumentUtil.setAcceptanceDate(sending.getAcceptanceDate(), doc);
        Element consignor = (Element)doc.getElementsByTagName("consignor").item(0);
        DocumentUtil.setString(sending.getGoodsDeclaration().getConsignor().getName(), consignor, "name");
        Element consignee = (Element)doc.getElementsByTagName("consignee").item(0);
        DocumentUtil.setString(sending.getGoodsDeclaration().getConsignee().getName(), consignee, "name");
        DocumentUtil.setSelection(sending.getGoodsDeclaration().getConsignee().getCountry(), consignee, "country");
        NodeList carrierList = doc.getElementsByTagName("carrier");
        if (carrierList.getLength() > 0) {
            Element carrier = (Element)carrierList.item(0);
            DocumentUtil.setString(sending.getGoodsDeclaration().getCarrier().getName(), carrier, "name");
        }
        Element declarant = (Element)doc.getElementsByTagName("declarant").item(0);
        DocumentUtil.setInteger(sending.getGoodsDeclaration().getDeclarant().getDeclarantNumber(), declarant, "declarantNumber");
        return sending;
    }
}

