/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.evv.evvexport.pm;

import ch.transsoft.edec.model.index.Index;
import ch.transsoft.edec.model.index.IndexEntry;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.jobs.evv.FetchEvvJobErrorHandler;
import ch.transsoft.edec.service.ezv.IEZVService;
import ch.transsoft.edec.service.ezv.evv.Role;
import ch.transsoft.edec.service.index.IArchiveChangeListener;
import ch.transsoft.edec.service.index.IIndexChangeListener;
import ch.transsoft.edec.service.index.sending.IIndexService;
import ch.transsoft.edec.ui.dialog.evv.evvexport.pm.EvvExportHandle;
import ch.transsoft.edec.ui.dialog.evv.evvexport.pm.EvvPm;
import ch.transsoft.edec.ui.dialog.evv.evvexport.pm.ListFetchingUpdate;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DateUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import javax.swing.SwingWorker;

public class ListFetcher
extends SwingWorker<Void, ListFetchingUpdate> {
    private final EvvPm evvPm;
    private final Set<String> sendings = new HashSet<String>();
    private Semaphore semaphore;

    public ListFetcher(EvvPm evvPm) {
        this.evvPm = evvPm;
        this.listSendings();
    }

    private void listSendings() {
        int fromYear = DateUtil.getYear(this.evvPm.getFromDate()) - 1;
        int toYear = DateUtil.getYear(this.evvPm.getToDate());
        HashSet<Integer> years = new HashSet<Integer>();
        for (int i2 = fromYear; i2 <= toYear; ++i2) {
            years.add(i2);
        }
        int permits = 1 + (-1 - years.size());
        this.semaphore = new Semaphore(permits);
        this.getIndexService().add(new IArchiveChangeListener<IndexEntry, Index>(){

            @Override
            public void clear() {
            }

            @Override
            public void changed(int year, Index archivePart) {
                ListFetcher.this.addSendings(archivePart);
            }
        });
        this.getIndexService().add(new IIndexChangeListener<IndexEntry, Index>(){

            @Override
            public void clear() {
            }

            @Override
            public void changed(Index newIndex) {
                ListFetcher.this.addSendings(newIndex);
            }
        });
        this.getIndexService().readIndex();
        this.getIndexService().readArchive(years);
    }

    private IIndexService getIndexService() {
        return Services.get(IIndexService.class);
    }

    @Override
    protected void done() {
        this.evvPm.finishFetchingList();
        if (this.isCancelled()) {
            return;
        }
        try {
            this.get();
        }
        catch (ExecutionException e2) {
            Throwable cause = e2.getCause();
            new FetchEvvJobErrorHandler(false).handleError(cause);
        }
        catch (Exception e3) {
            Check.fail(e3);
        }
    }

    @Override
    protected Void doInBackground() throws Exception {
        this.semaphore.acquire();
        if (this.isCancelled()) {
            return null;
        }
        List<DateUtil.DateRange> ranges = DateUtil.getRanges(this.evvPm.getFromDate(), this.evvPm.getToDate(), 10);
        for (DateUtil.DateRange current : ranges) {
            this.publish(current);
            HashSet<IEZVService.EvvExportListEntry> result = new HashSet<IEZVService.EvvExportListEntry>();
            Services.get(IEZVService.class).getEvvListExport(this.evvPm.getMode(), this.evvPm.getUid(), current.start, current.end, false, Role.Zollanmelder, result);
            Services.get(IEZVService.class).getEvvListExport(this.evvPm.getMode(), this.evvPm.getUid(), current.start, current.end, false, Role.Versender, result);
            if (this.isCancelled()) {
                return null;
            }
            this.publish((Set<IEZVService.EvvExportListEntry>)result);
        }
        return null;
    }

    private void publish(Set<IEZVService.EvvExportListEntry> entries) {
        ArrayList<EvvExportHandle> handles = new ArrayList<EvvExportHandle>();
        for (IEZVService.EvvExportListEntry handle : entries) {
            if (this.sendings.contains(handle.getCustomsDeclarationNumber())) continue;
            handles.add(this.createEvvHandle(handle));
        }
        ListFetchingUpdate update = new ListFetchingUpdate();
        update.setEvvListEntries(handles);
        this.publish(update);
    }

    private EvvExportHandle createEvvHandle(IEZVService.EvvExportListEntry handle) {
        EvvExportHandle result = new EvvExportHandle();
        result.setDate(handle.getDate());
        result.setCustomsDeclarationNumber(handle.getCustomsDeclarationNumber());
        result.setConsignee(handle.getConsignee());
        return result;
    }

    private void publish(DateUtil.DateRange current) {
        ListFetchingUpdate update = new ListFetchingUpdate();
        update.setMessage(DateUtil.formatDate(current.start) + " - " + DateUtil.formatDate(current.end));
        this.publish(update);
    }

    private void addSendings(Index index) {
        for (IndexEntry current : index.getEntryList()) {
            if (!current.getCustomsDeclarationNumber().isInitialized()) continue;
            this.sendings.add(current.getCustomsDeclarationNumber().getValue());
        }
        this.semaphore.release();
    }

    @Override
    protected void process(List<ListFetchingUpdate> chunks) {
        if (this.isCancelled()) {
            return;
        }
        for (ListFetchingUpdate update : chunks) {
            this.evvPm.handle(update);
        }
    }
}

