/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.export.evvexport.pm;

import ch.transsoft.edec.ui.dialog.export.evvexport.pm.ExpColDesc;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DateUtil;
import java.util.Date;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExpXmlDomWrapper {
    private final List<ExpColDesc> headers;
    private final List<ExpColDesc> items;
    private final Node receiptNode;
    private final Node evvRootNode;
    private XPathExpression receiptExpression = ExpXmlDomWrapper.createExpression("/Envelope/Body/receiptRequestResponse");
    private XPathExpression evvRootExpression = ExpXmlDomWrapper.createExpression("./taxationDecisionExport");
    private XPathExpression goodsItemExpression = ExpXmlDomWrapper.createExpression("./goodsItem");
    private XPathExpression acceptanceDateExpression = ExpXmlDomWrapper.createExpression("./acceptanceDate");
    private boolean headerFieldAdded = false;
    private final String delimiter;

    public ExpXmlDomWrapper(Document evv, List<ExpColDesc> header, List<ExpColDesc> items, String delimiter) throws Exception {
        this.delimiter = delimiter;
        Check.assertNotNull(evv);
        this.headers = header;
        this.items = items;
        this.receiptNode = (Node)this.receiptExpression.evaluate(evv, XPathConstants.NODE);
        this.evvRootNode = (Node)this.evvRootExpression.evaluate(this.receiptNode, XPathConstants.NODE);
    }

    public void addLines(List<String> result) throws Exception {
        String header = this.createHeader(this.delimiter);
        NodeList goodsItems = (NodeList)this.goodsItemExpression.evaluate(this.evvRootNode, XPathConstants.NODESET);
        for (int i2 = 0; i2 < goodsItems.getLength(); ++i2) {
            this.addLines(this.delimiter, header, goodsItems.item(i2), result);
        }
    }

    private void addLines(String delimiter, String header, Node current, List<String> resultList) throws Exception {
        StringBuilder result = new StringBuilder(header);
        boolean delimiterNeeded = this.headerFieldAdded;
        for (ExpColDesc col : this.items) {
            if (!col.isEnabled()) continue;
            if (delimiterNeeded) {
                result.append(delimiter);
            }
            this.append(current, result, col);
            delimiterNeeded = true;
        }
        resultList.add(result.toString());
    }

    private void append(Node current, StringBuilder result, ExpColDesc col) throws Exception {
        String resultStr = col.getString(current);
        resultStr = resultStr.replaceAll("\r|\n|" + this.delimiter, " ");
        result.append(resultStr);
    }

    private String createHeader(String delimiter) throws Exception {
        StringBuilder result = new StringBuilder();
        for (ExpColDesc col : this.headers) {
            if (!col.isEnabled()) continue;
            if (this.headerFieldAdded) {
                result.append(delimiter);
            }
            if (col.getCategory() == ExpColDesc.DescCategory.global) {
                result.append(col.getString(this.receiptNode));
            } else if (col.getCategory() == ExpColDesc.DescCategory.header) {
                result.append(col.getString(this.evvRootNode));
            } else {
                Check.fail("unexpected category: " + col.getCategory());
            }
            this.headerFieldAdded = true;
        }
        return result.toString();
    }

    public static XPathExpression createExpression(String path) {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            return xpath.compile(path);
        }
        catch (Exception e2) {
            throw Check.fail(e2);
        }
    }

    public Date getAcceptanceDate() {
        try {
            String dateStr = (String)this.acceptanceDateExpression.evaluate(this.evvRootNode, XPathConstants.STRING);
            return DateUtil.getDate(dateStr);
        }
        catch (XPathExpressionException e2) {
            throw Check.fail(e2);
        }
    }
}

