/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.export.evvimport.pm;

import ch.transsoft.edec.model.config.conf.extract.ImportExtractInfo;
import ch.transsoft.edec.model.infra.node.FileNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.ExtractEvvImportJob;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import ch.transsoft.edec.ui.dialog.export.evvimport.pm.IImportColDesc;
import ch.transsoft.edec.ui.dialog.export.evvimport.pm.ImpColDescFactory;
import ch.transsoft.edec.ui.dialog.export.evvimport.pm.ImpDataExportList;
import ch.transsoft.edec.ui.pm.model.BooleanPm;
import ch.transsoft.edec.ui.pm.model.IBooleanPm;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.ui.pm.model.SelectionPm;
import ch.transsoft.edec.util.DateUtil;
import ch.transsoft.edec.util.FileChooserUtil;
import ch.transsoft.edec.util.FileUtil;
import com.toedter.calendar.JDateChooser;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class ImpDataExportPm
implements IPm {
    private final JDateChooser from = new JDateChooser();
    private final JDateChooser to = new JDateChooser();
    private final SelectionPm delimiterPm;
    private final BooleanPm showHeader;
    private final JLabel statusLabel;
    private final Component progressBar = this.createProgressBar();
    private final ImportExtractInfo config;
    private final ImpDataExportList headerDataListPm;
    private final ImpDataExportList itemDataListPm;
    private final List<IImportColDesc> items;
    private final List<IImportColDesc> headers;

    public ImpDataExportPm() {
        this.statusLabel = new JLabel();
        this.hideStatusInfo();
        this.config = Services.get(IConfigService.class).getImportExtractInfo();
        this.delimiterPm = new SelectionPm(this.config.getDelimiter());
        this.showHeader = new BooleanPm(this.config.getShowHeader());
        if (this.config.getFrom().isInitialized()) {
            this.from.setDate(this.config.getFrom().getValue());
        }
        if (this.config.getTo().isInitialized()) {
            this.to.setDate(this.config.getTo().getValue());
        }
        this.headers = ImpColDescFactory.getHeaderList(this.config.getColInfos());
        this.headerDataListPm = new ImpDataExportList(this.headers, null, this);
        this.items = ImpColDescFactory.getItemList(this.config.getColInfos());
        this.itemDataListPm = new ImpDataExportList(this.items, this.headerDataListPm, this);
    }

    public boolean export() {
        if (!this.rangeValid()) {
            DialogUtil.showWarningDialog(Services.getText(4706), Services.getText(4707));
            return false;
        }
        FileNode lastFolder = Services.get(IConfigService.class).getPreferences().getLastUsedFolders().getImportDataExpFolder();
        File[] files = FileChooserUtil.chooseFiles(lastFolder.getValue(), Services.getText(5502), "evvImport.csv", Services.getText(5503));
        if (files == null) {
            return false;
        }
        if (files.length == 0) {
            return false;
        }
        lastFolder.setValue(files[0].getParentFile());
        Services.get(IConfigService.class).savePreferences();
        File file = FileUtil.addExtension(files[0], "csv");
        this.config.getFrom().setValue(this.getFromDate());
        this.config.getTo().setValue(this.getToDate());
        this.saveConfiguration();
        ExtractEvvImportJob job = new ExtractEvvImportJob(this.headers, this.items, this.getFromDate(), this.getToDate(), this.getDelimiterStr(), this.showHeader(), file);
        Services.get(IBackendService.class).put(job);
        return true;
    }

    private String getDelimiterStr() {
        return this.getDelimiter().getCurrentValue().getKey();
    }

    private boolean showHeader() {
        return this.getShowHeader().isSelected();
    }

    private boolean rangeValid() {
        if (this.getFromDate() == null) {
            return false;
        }
        if (this.getToDate() == null) {
            return false;
        }
        return this.getFromDate().compareTo(this.getToDate()) <= 0;
    }

    public Date getFromDate() {
        if (this.from.getDate() == null) {
            return null;
        }
        return DateUtil.getNormalizedDate(this.from.getDate());
    }

    public Date getToDate() {
        if (this.to.getDate() == null) {
            return null;
        }
        return DateUtil.getNormalizedDate(this.to.getDate());
    }

    public Component getFrom() {
        return this.from;
    }

    public Component getTo() {
        return this.to;
    }

    private JProgressBar createProgressBar() {
        JProgressBar result = new JProgressBar();
        result.setIndeterminate(true);
        return result;
    }

    public void hideStatusInfo() {
        this.statusLabel.setVisible(false);
        this.progressBar.setVisible(false);
    }

    public void setStatusInfo(String text) {
        this.statusLabel.setText("<html>" + text + "</html>");
        this.statusLabel.setVisible(true);
        this.progressBar.setVisible(true);
    }

    public JLabel getStatusLabel() {
        return this.statusLabel;
    }

    public Component getProgressBar() {
        return this.progressBar;
    }

    public ImpDataExportList getHeaderPm() {
        return this.headerDataListPm;
    }

    public ImpDataExportList getItemPm() {
        return this.itemDataListPm;
    }

    public void saveConfiguration() {
        ArrayList<IImportColDesc> list = new ArrayList<IImportColDesc>();
        list.addAll(this.headerDataListPm.getList());
        list.addAll(this.itemDataListPm.getList());
        this.config.update(list);
        Services.get(IConfigService.class).saveImportExtractInfo(this.config);
    }

    public void updateUi() {
        this.headerDataListPm.fireColumnLetterChanged();
        this.itemDataListPm.fireColumnLetterChanged();
    }

    public SelectionPm getDelimiter() {
        return this.delimiterPm;
    }

    public IBooleanPm getShowHeader() {
        return this.showHeader;
    }
}

