/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.export.evvimport.pm;

import ch.transsoft.edec.model.evvimport.receipt.ImportSending;
import ch.transsoft.edec.ui.dialog.export.evvimport.pm.AbstractColDesc;
import ch.transsoft.edec.ui.dialog.export.evvimport.pm.IImportColDesc;
import ch.transsoft.edec.ui.dialog.export.evvimport.pm.ImpItemKey;
import ch.transsoft.edec.ui.dialog.export.evvimport.pm.ImpItemValue;
import ch.transsoft.edec.util.Check;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImpXmlDomWrapper {
    private final List<IImportColDesc> headers;
    private final List<IImportColDesc> items;
    private final Document vvm;
    private final Document vvz;
    private final Document rbm;
    private final Document rbz;
    private final XPathExpression receiptExpression = ImpXmlDomWrapper.createExpression("/Envelope/Body/receiptRequestResponse");
    private final XPathExpression vvmRootExpression = ImpXmlDomWrapper.createExpression("./taxationDecisionVAT");
    private final XPathExpression vvzRootExpression = ImpXmlDomWrapper.createExpression("./taxationDecisionCustomsDuties");
    private final XPathExpression rbmRootExpression = ImpXmlDomWrapper.createExpression("./refundVAT");
    private final XPathExpression rbzRootExpression = ImpXmlDomWrapper.createExpression("./refundCustomsDuties");
    private final XPathExpression goodsItemExpression = ImpXmlDomWrapper.createExpression("./goodsItem");
    private final XPathExpression customsItemNumberExpression = ImpXmlDomWrapper.createExpression("./customsItemNumber");
    private final XPathExpression commodityCodeExpression = ImpXmlDomWrapper.createExpression("./commodityCode");
    private final Map<ImpItemKey, ImpItemValue> itemMap = new Hashtable<ImpItemKey, ImpItemValue>();
    private boolean headerFieldAdded = false;
    private final ImportSending sending;
    private final String delimiter;

    public ImpXmlDomWrapper(ImportSending sending, Document vvm, Document vvz, Document rbm, Document rbz, List<IImportColDesc> header, List<IImportColDesc> items, String delimiter) {
        this.sending = sending;
        this.delimiter = delimiter;
        Check.assertTrue(vvm != null || vvz != null || rbm != null || rbz != null, "vvm, vvz, rbm and rbz are null");
        this.vvm = vvm;
        this.vvz = vvz;
        this.rbm = rbm;
        this.rbz = rbz;
        this.headers = header;
        this.items = items;
    }

    public void addLines(List<String> result) throws Exception {
        Node root;
        Object receipt;
        String header = this.createHeader(this.delimiter);
        if (this.vvm != null) {
            receipt = (Node)this.receiptExpression.evaluate(this.vvm, XPathConstants.NODE);
            root = (Node)this.vvmRootExpression.evaluate(receipt, XPathConstants.NODE);
            this.addPositions(root, AbstractColDesc.DescCategory.vvm);
        }
        if (this.vvz != null) {
            receipt = (Node)this.receiptExpression.evaluate(this.vvz, XPathConstants.NODE);
            root = (Node)this.vvzRootExpression.evaluate(receipt, XPathConstants.NODE);
            this.addPositions(root, AbstractColDesc.DescCategory.vvz);
        }
        for (ImpItemValue current : this.itemMap.values()) {
            this.addLines(header, current, result);
        }
        if (this.rbm != null) {
            receipt = (Node)this.receiptExpression.evaluate(this.rbm, XPathConstants.NODE);
            root = (Node)this.rbmRootExpression.evaluate(receipt, XPathConstants.NODE);
            this.addRbmPosition(result, header, root);
        }
        if (this.rbz != null) {
            receipt = (Node)this.receiptExpression.evaluate(this.rbz, XPathConstants.NODE);
            root = (Node)this.rbzRootExpression.evaluate(receipt, XPathConstants.NODE);
            this.addRbzPosition(result, header, root);
        }
    }

    private void addRbmPosition(List<String> result, String header, Node root) throws XPathExpressionException {
        StringBuilder line = new StringBuilder(header);
        boolean delimiterNeeded = this.headerFieldAdded;
        XPathExpression expressionDescription = ImpXmlDomWrapper.createExpression("./documentInformation/documentTitle");
        XPathExpression expressionAmount = ImpXmlDomWrapper.createExpression("./valuationSummary/VAT/totalAmount");
        for (IImportColDesc col : this.items) {
            String value;
            if (!col.isEnabled()) continue;
            if (delimiterNeeded) {
                line.append(this.delimiter);
            }
            if (col.getId().equals(Integer.toString(118))) {
                value = (String)expressionAmount.evaluate(root, XPathConstants.STRING);
                double doubleValue = -Double.parseDouble(value);
                line.append(doubleValue);
            } else if (col.getId().equals(Integer.toString(102))) {
                value = (String)expressionDescription.evaluate(root, XPathConstants.STRING);
                line.append(value);
            } else {
                line.append("");
            }
            delimiterNeeded = true;
        }
        result.add(line.toString());
    }

    private void addRbzPosition(List<String> result, String header, Node root) throws XPathExpressionException {
        StringBuilder line = new StringBuilder(header);
        boolean delimiterNeeded = this.headerFieldAdded;
        XPathExpression expressionDescription = ImpXmlDomWrapper.createExpression("./documentInformation/documentTitle");
        XPathExpression expressionAmount = ImpXmlDomWrapper.createExpression("./valuationSummary/dutyAndAdditionalTaxes/detailAmount/amount");
        for (IImportColDesc col : this.items) {
            String value;
            if (!col.isEnabled()) continue;
            if (delimiterNeeded) {
                line.append(this.delimiter);
            }
            if (col.getId().equals(Integer.toString(130))) {
                value = (String)expressionAmount.evaluate(root, XPathConstants.STRING);
                double doubleValue = -Double.parseDouble(value);
                line.append(doubleValue);
            } else if (col.getId().equals(Integer.toString(102))) {
                value = (String)expressionDescription.evaluate(root, XPathConstants.STRING);
                line.append(value);
            } else {
                line.append("");
            }
            delimiterNeeded = true;
        }
        result.add(line.toString());
    }

    private void addPositions(Node root, AbstractColDesc.DescCategory category) throws Exception {
        NodeList goodsItems = (NodeList)this.goodsItemExpression.evaluate(root, XPathConstants.NODESET);
        for (int i2 = 0; i2 < goodsItems.getLength(); ++i2) {
            this.addPosition(goodsItems.item(i2), category);
        }
    }

    private void addPosition(Node item, AbstractColDesc.DescCategory category) throws Exception {
        String customsItemNumber = (String)this.customsItemNumberExpression.evaluate(item, XPathConstants.STRING);
        Check.assertNotNull(customsItemNumber);
        String commodityCode = (String)this.commodityCodeExpression.evaluate(item, XPathConstants.STRING);
        Check.assertNotNull(commodityCode);
        ImpItemKey key = new ImpItemKey(customsItemNumber, this.sending.getDate().getStringValue(), commodityCode);
        ImpItemValue impItemValue = this.itemMap.get(key);
        if (impItemValue == null) {
            impItemValue = new ImpItemValue();
            this.itemMap.put(key, impItemValue);
        }
        if (category == AbstractColDesc.DescCategory.vvm) {
            impItemValue.setVvm(item);
        } else if (category == AbstractColDesc.DescCategory.vvz) {
            impItemValue.setVvz(item);
        } else {
            Check.fail("unexpected DescCategory: " + category);
        }
    }

    private void addLines(String header, ImpItemValue current, List<String> resultList) throws Exception {
        StringBuilder result = new StringBuilder(header);
        boolean delimiterNeeded = this.headerFieldAdded;
        for (IImportColDesc col : this.items) {
            if (!col.isEnabled()) continue;
            if (delimiterNeeded) {
                result.append(this.delimiter);
            }
            this.append(current, result, col);
            delimiterNeeded = true;
        }
        resultList.add(result.toString());
    }

    private void append(ImpItemValue current, StringBuilder result, IImportColDesc col) throws Exception {
        String resultStr = col.getString(this.getNode(col, current), this.sending);
        resultStr = resultStr.replaceAll("\r|\n|" + this.delimiter, " ");
        result.append(resultStr);
    }

    private Node getNode(IImportColDesc col, ImpItemValue current) {
        switch (col.getCategory()) {
            case common: {
                return current.getCommonNode();
            }
            case vvm: {
                return current.getVvmNode();
            }
            case vvz: {
                return current.getVvzNode();
            }
        }
        throw Check.fail("unexpected desc:" + col.getId());
    }

    private String createHeader(String delimiter) throws Exception {
        StringBuilder result = new StringBuilder();
        Node headerNode = this.getHeaderNode();
        for (IImportColDesc col : this.headers) {
            if (!col.isEnabled()) continue;
            if (this.headerFieldAdded) {
                result.append(delimiter);
            }
            if (col.getCategory() == AbstractColDesc.DescCategory.header) {
                result.append(col.getString(headerNode, this.sending));
            } else {
                Check.fail("unexpected category: " + col.getCategory());
            }
            this.headerFieldAdded = true;
        }
        return result.toString();
    }

    private Document getDoc() {
        if (this.vvm != null) {
            return this.vvm;
        }
        if (this.vvz != null) {
            return this.vvz;
        }
        if (this.rbm != null) {
            return this.rbm;
        }
        return this.rbz;
    }

    private Node getReceiptNode() throws Exception {
        return (Node)this.receiptExpression.evaluate(this.getDoc(), XPathConstants.NODE);
    }

    private Node getHeaderNode() throws Exception {
        Node receiptNode = this.getReceiptNode();
        if (this.vvm != null) {
            return (Node)this.vvmRootExpression.evaluate(receiptNode, XPathConstants.NODE);
        }
        if (this.vvz != null) {
            return (Node)this.vvzRootExpression.evaluate(receiptNode, XPathConstants.NODE);
        }
        if (this.rbm != null) {
            return (Node)this.rbmRootExpression.evaluate(receiptNode, XPathConstants.NODE);
        }
        return (Node)this.rbzRootExpression.evaluate(receiptNode, XPathConstants.NODE);
    }

    public static XPathExpression createExpression(String path) {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            return xpath.compile(path);
        }
        catch (Exception e2) {
            throw Check.fail(e2);
        }
    }
}

