/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.export.evvimport.pm;

import ch.transsoft.edec.model.config.conf.extract.IColInfo;
import ch.transsoft.edec.model.evvimport.receipt.ImportSending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.ui.dialog.export.evvimport.pm.AbstractColDesc;
import ch.transsoft.edec.ui.dialog.export.evvimport.pm.ImpXmlDomWrapper;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import org.w3c.dom.Node;

public class ImportColDescXml
extends AbstractColDesc {
    private final String path;
    private final XPathExpression expression;
    private final boolean suppressZeroValues;

    public static ImportColDescXml createHeader(int id, int label, int categoryId, String path, boolean defaultEnablement, IColInfo colInfo) {
        return new ImportColDescXml(id, label, categoryId, AbstractColDesc.DescCategory.header, path, colInfo.isEnabled(id, defaultEnablement));
    }

    public static ImportColDescXml createItem(int id, int label, int categoryId, AbstractColDesc.DescCategory category, String path, boolean defaultEnablement, IColInfo colInfo) {
        return new ImportColDescXml(id, label, categoryId, category, path, colInfo.isEnabled(id, defaultEnablement));
    }

    public static ImportColDescXml createItem(int id, int label, int categoryId, AbstractColDesc.DescCategory category, String path, boolean defaultEnablement, IColInfo colInfo, boolean suppressZeroValues) {
        return new ImportColDescXml(id, label, categoryId, category, path, colInfo.isEnabled(id, defaultEnablement), suppressZeroValues);
    }

    private ImportColDescXml(int id, int label, int categoryId, AbstractColDesc.DescCategory category, String path, boolean enabled) {
        super(id, categoryId, category, enabled, label);
        this.path = path;
        this.expression = ImpXmlDomWrapper.createExpression(path);
        this.suppressZeroValues = false;
    }

    private ImportColDescXml(int id, int label, int categoryId, AbstractColDesc.DescCategory category, String path, boolean enabled, boolean suppressZeroValues) {
        super(id, categoryId, category, enabled, label);
        this.path = path;
        this.expression = ImpXmlDomWrapper.createExpression(path);
        this.suppressZeroValues = suppressZeroValues;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getId() {
        return Integer.toString(this.id);
    }

    @Override
    public String getCaption() {
        if (this.label == 0) {
            String[] segs = this.path.split("/");
            return segs[segs.length - 1];
        }
        return Services.getText(this.label);
    }

    public String getPath() {
        return this.path;
    }

    public static boolean isCellEditable(int columnIndex) {
        return columnIndex == 3;
    }

    public static int getColumnCount() {
        return 4;
    }

    @Override
    public String getString(Node node, ImportSending sending) throws Exception {
        if (node == null) {
            return "";
        }
        String value = (String)this.expression.evaluate(node, XPathConstants.STRING);
        if (this.suppressZeroValues && value.equals("0")) {
            return "";
        }
        return value;
    }
}

