/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.info.pm;

import ch.transsoft.edec.ui.dialog.DialogUtil;
import ch.transsoft.edec.ui.gui.control.icondisplay.IconDisplay;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.TextUtil;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingWorker;

public final class ConnectionChecker {
    private final IconDisplay iconDisplay;
    private final SwingWorker<Exception, Void> worker;
    private final Window parent;

    public ConnectionChecker(final ConnectionChecker next, Window parent, IconDisplay iconDisplay, final Executor executor) {
        this.parent = parent;
        this.iconDisplay = iconDisplay;
        this.worker = new SwingWorker<Exception, Void>(){

            @Override
            protected Exception doInBackground() {
                try {
                    executor.check();
                    return null;
                }
                catch (Exception e2) {
                    return e2;
                }
            }

            @Override
            protected void done() {
                try {
                    Exception result = (Exception)this.get();
                    ConnectionChecker.this.handle(result);
                }
                catch (Exception e2) {
                    Check.fail(e2);
                }
                if (next != null) {
                    next.execute();
                }
            }
        };
    }

    public void execute() {
        this.worker.execute();
    }

    private void handle(Exception result) {
        if (result == null) {
            this.iconDisplay.setIcon("icon/ConCheckGreen.png");
        } else {
            result.printStackTrace();
            this.iconDisplay.setIcon("icon/ConCheckRed.png");
            this.iconDisplay.addMouseListener(this.createMouseListener(result));
            this.iconDisplay.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    private MouseAdapter createMouseListener(final Exception result) {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                String text = TextUtil.getStackTrace(result);
                DialogUtil.showBigText(ConnectionChecker.this.parent, "Fehler", text);
            }
        };
    }

    public static interface Executor {
        public void check() throws Exception;
    }
}

